/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.partition.PartitionStatistics;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.utils.InternalRowPartitionComputer;

@Public
public class PartitionEntry {
    private final BinaryRow partition;
    private final long recordCount;
    private final long fileSizeInBytes;
    private final long fileCount;
    private final long lastFileCreationTime;

    public PartitionEntry(BinaryRow partition, long recordCount, long fileSizeInBytes, long fileCount, long lastFileCreationTime) {
        this.partition = partition;
        this.recordCount = recordCount;
        this.fileSizeInBytes = fileSizeInBytes;
        this.fileCount = fileCount;
        this.lastFileCreationTime = lastFileCreationTime;
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public long recordCount() {
        return this.recordCount;
    }

    public long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public long fileCount() {
        return this.fileCount;
    }

    public long lastFileCreationTime() {
        return this.lastFileCreationTime;
    }

    public PartitionEntry merge(PartitionEntry entry) {
        return new PartitionEntry(this.partition, this.recordCount + entry.recordCount, this.fileSizeInBytes + entry.fileSizeInBytes, this.fileCount + entry.fileCount, Math.max(this.lastFileCreationTime, entry.lastFileCreationTime));
    }

    public Partition toPartition(InternalRowPartitionComputer computer) {
        return new Partition(computer.generatePartValues((InternalRow)this.partition), this.recordCount, this.fileSizeInBytes, this.fileCount, this.lastFileCreationTime, false);
    }

    public PartitionStatistics toPartitionStatistics(InternalRowPartitionComputer computer) {
        return new PartitionStatistics(computer.generatePartValues((InternalRow)this.partition), this.recordCount, this.fileSizeInBytes, this.fileCount, this.lastFileCreationTime);
    }

    public static PartitionEntry fromManifestEntry(ManifestEntry entry) {
        return PartitionEntry.fromDataFile(entry.partition(), entry.kind(), entry.file());
    }

    public static PartitionEntry fromDataFile(BinaryRow partition, FileKind kind, DataFileMeta file) {
        long recordCount = file.rowCount();
        long fileSizeInBytes = file.fileSize();
        long fileCount = 1L;
        if (kind == FileKind.DELETE) {
            recordCount = -recordCount;
            fileSizeInBytes = -fileSizeInBytes;
            fileCount = -fileCount;
        }
        return new PartitionEntry(partition, recordCount, fileSizeInBytes, fileCount, file.creationTimeEpochMillis());
    }

    public static Collection<PartitionEntry> merge(Collection<ManifestEntry> fileEntries) {
        HashMap<BinaryRow, PartitionEntry> partitions = new HashMap<BinaryRow, PartitionEntry>();
        for (ManifestEntry entry : fileEntries) {
            PartitionEntry partitionEntry = PartitionEntry.fromManifestEntry(entry);
            partitions.compute(entry.partition(), (part, old) -> old == null ? partitionEntry : old.merge(partitionEntry));
        }
        return partitions.values();
    }

    public static Collection<PartitionEntry> mergeSplits(Collection<DataSplit> splits) {
        HashMap<BinaryRow, PartitionEntry> partitions = new HashMap<BinaryRow, PartitionEntry>();
        for (DataSplit split : splits) {
            BinaryRow partition = split.partition();
            for (DataFileMeta file : split.dataFiles()) {
                PartitionEntry partitionEntry = PartitionEntry.fromDataFile(partition, FileKind.ADD, file);
                partitions.compute(partition, (part, old) -> old == null ? partitionEntry : old.merge(partitionEntry));
            }
        }
        return partitions.values();
    }

    public static void merge(Collection<PartitionEntry> from, Map<BinaryRow, PartitionEntry> to) {
        for (PartitionEntry entry : from) {
            to.compute(entry.partition(), (part, old) -> old == null ? entry : old.merge(entry));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionEntry that = (PartitionEntry)o;
        return this.recordCount == that.recordCount && this.fileSizeInBytes == that.fileSizeInBytes && this.fileCount == that.fileCount && this.lastFileCreationTime == that.lastFileCreationTime && Objects.equals(this.partition, that.partition);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.recordCount, this.fileSizeInBytes, this.fileCount, this.lastFileCreationTime);
    }
}

