/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntrySerializer;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.utils.SerializationUtils;

@Public
public class ManifestEntry
implements FileEntry {
    public static final RowType SCHEMA = new RowType(false, Arrays.asList(new DataField(0, "_KIND", (DataType)new TinyIntType(false)), new DataField(1, "_PARTITION", (DataType)SerializationUtils.newBytesType(false)), new DataField(2, "_BUCKET", (DataType)new IntType(false)), new DataField(3, "_TOTAL_BUCKETS", (DataType)new IntType(false)), new DataField(4, "_FILE", (DataType)DataFileMeta.SCHEMA)));
    private final FileKind kind;
    private final BinaryRow partition;
    private final int bucket;
    private final int totalBuckets;
    private final DataFileMeta file;
    private static final ThreadLocal<ManifestEntrySerializer> SERIALIZER_THREAD_LOCAL = ThreadLocal.withInitial(ManifestEntrySerializer::new);

    public ManifestEntry(FileKind kind, BinaryRow partition, int bucket, int totalBuckets, DataFileMeta file) {
        this.kind = kind;
        this.partition = partition;
        this.bucket = bucket;
        this.totalBuckets = totalBuckets;
        this.file = file;
    }

    @Override
    public FileKind kind() {
        return this.kind;
    }

    @Override
    public BinaryRow partition() {
        return this.partition;
    }

    @Override
    public int bucket() {
        return this.bucket;
    }

    @Override
    public int level() {
        return this.file.level();
    }

    @Override
    public String fileName() {
        return this.file.fileName();
    }

    @Override
    @Nullable
    public String externalPath() {
        return this.file.externalPath().orElse(null);
    }

    @Override
    public BinaryRow minKey() {
        return this.file.minKey();
    }

    @Override
    public BinaryRow maxKey() {
        return this.file.maxKey();
    }

    @Override
    public List<String> extraFiles() {
        return this.file.extraFiles();
    }

    public int totalBuckets() {
        return this.totalBuckets;
    }

    public DataFileMeta file() {
        return this.file;
    }

    @Override
    public FileEntry.Identifier identifier() {
        return new FileEntry.Identifier(this.partition, this.bucket, this.file.level(), this.file.fileName(), this.file.extraFiles(), this.file.embeddedIndex(), this.externalPath());
    }

    public ManifestEntry copyWithoutStats() {
        return new ManifestEntry(this.kind, this.partition, this.bucket, this.totalBuckets, this.file.copyWithoutStats());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManifestEntry)) {
            return false;
        }
        ManifestEntry that = (ManifestEntry)o;
        return Objects.equals((Object)this.kind, (Object)that.kind) && Objects.equals(this.partition, that.partition) && this.bucket == that.bucket && this.totalBuckets == that.totalBuckets && Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.partition, this.bucket, this.totalBuckets, this.file});
    }

    public String toString() {
        return String.format("{%s, %s, %d, %d, %s}", new Object[]{this.kind, this.partition, this.bucket, this.totalBuckets, this.file});
    }

    public static long recordCount(List<ManifestEntry> manifestEntries) {
        return manifestEntries.stream().mapToLong(manifest -> manifest.file().rowCount()).sum();
    }

    public static long recordCountAdd(List<ManifestEntry> manifestEntries) {
        return manifestEntries.stream().filter(manifestEntry -> FileKind.ADD.equals((Object)manifestEntry.kind())).mapToLong(manifest -> manifest.file().rowCount()).sum();
    }

    public static long recordCountDelete(List<ManifestEntry> manifestEntries) {
        return manifestEntries.stream().filter(manifestEntry -> FileKind.DELETE.equals((Object)manifestEntry.kind())).mapToLong(manifest -> manifest.file().rowCount()).sum();
    }

    public byte[] toBytes() throws IOException {
        return SERIALIZER_THREAD_LOCAL.get().serializeToBytes(this);
    }

    public ManifestEntry fromBytes(byte[] bytes) throws IOException {
        return (ManifestEntry)SERIALIZER_THREAD_LOCAL.get().deserializeFromBytes(bytes);
    }
}

