/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.jdbc.DistributedLockDialectFactory;
import org.apache.paimon.jdbc.JdbcClientPool;
import org.apache.paimon.jdbc.JdbcDistributedLockDialect;
import org.apache.paimon.options.Options;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcUtils.class);
    public static final String CATALOG_TABLE_NAME = "paimon_tables";
    public static final String CATALOG_KEY = "catalog_key";
    public static final String TABLE_DATABASE = "database_name";
    public static final String TABLE_NAME = "table_name";
    static final String CREATE_CATALOG_TABLE = "CREATE TABLE paimon_tables(catalog_key VARCHAR(255) NOT NULL,database_name VARCHAR(255) NOT NULL,table_name VARCHAR(255) NOT NULL, PRIMARY KEY (catalog_key, database_name, table_name))";
    static final String GET_TABLE_SQL = "SELECT * FROM paimon_tables WHERE catalog_key = ? AND database_name = ? AND table_name = ? ";
    static final String LIST_TABLES_SQL = "SELECT * FROM paimon_tables WHERE catalog_key = ? AND database_name = ?";
    static final String DELETE_TABLES_SQL = "DELETE FROM  paimon_tables WHERE catalog_key = ? AND database_name = ?";
    static final String RENAME_TABLE_SQL = "UPDATE paimon_tables SET database_name = ? , table_name = ?  WHERE catalog_key = ? AND database_name = ? AND table_name = ? ";
    static final String DROP_TABLE_SQL = "DELETE FROM paimon_tables WHERE catalog_key = ? AND database_name = ? AND table_name = ? ";
    static final String GET_DATABASE_SQL = "SELECT database_name FROM paimon_tables WHERE catalog_key = ? AND database_name = ? LIMIT 1";
    static final String LIST_ALL_TABLE_DATABASES_SQL = "SELECT DISTINCT database_name FROM paimon_tables WHERE catalog_key = ?";
    static final String DO_COMMIT_CREATE_TABLE_SQL = "INSERT INTO paimon_tables (catalog_key, database_name, table_name)  VALUES (?,?,?)";
    static final String DATABASE_PROPERTIES_TABLE_NAME = "paimon_database_properties";
    static final String DATABASE_NAME = "database_name";
    static final String DATABASE_PROPERTY_KEY = "property_key";
    static final String DATABASE_PROPERTY_VALUE = "property_value";
    static final String CREATE_DATABASE_PROPERTIES_TABLE = "CREATE TABLE paimon_database_properties(catalog_key VARCHAR(255) NOT NULL,database_name VARCHAR(255) NOT NULL,property_key VARCHAR(255),property_value VARCHAR(1000),PRIMARY KEY (catalog_key, database_name, property_key))";
    static final String GET_DATABASE_PROPERTIES_SQL = "SELECT database_name FROM paimon_database_properties WHERE catalog_key = ? AND database_name = ? ";
    static final String INSERT_DATABASE_PROPERTIES_SQL = "INSERT INTO paimon_database_properties (catalog_key, database_name, property_key, property_value) VALUES ";
    static final String INSERT_PROPERTIES_VALUES_BASE = "(?,?,?,?)";
    static final String GET_ALL_DATABASE_PROPERTIES_SQL = "SELECT *  FROM paimon_database_properties WHERE catalog_key = ? AND database_name = ? ";
    static final String DELETE_DATABASE_PROPERTIES_SQL = "DELETE FROM paimon_database_properties WHERE catalog_key = ? AND database_name = ? AND property_key IN ";
    static final String DELETE_ALL_DATABASE_PROPERTIES_SQL = "DELETE FROM paimon_database_properties WHERE catalog_key = ? AND database_name = ?";
    static final String LIST_ALL_PROPERTY_DATABASES_SQL = "SELECT DISTINCT database_name FROM paimon_database_properties WHERE catalog_key = ?";
    static final String DISTRIBUTED_LOCKS_TABLE_NAME = "paimon_distributed_locks";
    static final String LOCK_ID = "lock_id";
    static final String ACQUIRED_AT = "acquired_at";
    static final String EXPIRE_TIME = "expire_time_seconds";

    public static Properties extractJdbcConfiguration(Map<String, String> properties, String prefix) {
        Properties result = new Properties();
        properties.forEach((key, value) -> {
            if (key.startsWith(prefix)) {
                result.put(key.substring(prefix.length()), value);
            }
        });
        return result;
    }

    public static Map<String, String> getTable(JdbcClientPool connections, String storeKey, String databaseName, String tableName) throws SQLException, InterruptedException {
        return (Map)connections.run(conn -> {
            HashMap table = Maps.newHashMap();
            try (PreparedStatement sql = conn.prepareStatement(GET_TABLE_SQL);){
                sql.setString(1, storeKey);
                sql.setString(2, databaseName);
                sql.setString(3, tableName);
                ResultSet rs = sql.executeQuery();
                if (rs.next()) {
                    table.put(CATALOG_KEY, rs.getString(CATALOG_KEY));
                    table.put("database_name", rs.getString("database_name"));
                    table.put(TABLE_NAME, rs.getString(TABLE_NAME));
                }
                rs.close();
            }
            return table;
        });
    }

    public static void updateTable(JdbcClientPool connections, String storeKey, Identifier fromTable, Identifier toTable) {
        int updatedRecords = JdbcUtils.execute((SQLException err) -> {
            if (err instanceof SQLIntegrityConstraintViolationException || err.getMessage() != null && err.getMessage().contains("constraint failed")) {
                throw new RuntimeException(String.format("Table already exists: %s", toTable));
            }
        }, connections, RENAME_TABLE_SQL, toTable.getDatabaseName(), toTable.getObjectName(), storeKey, fromTable.getDatabaseName(), fromTable.getObjectName());
        if (updatedRecords == 1) {
            LOG.info("Renamed table from {}, to {}", (Object)fromTable, (Object)toTable);
        } else {
            if (updatedRecords == 0) {
                throw new RuntimeException(String.format("Table does not exist: %s", fromTable));
            }
            LOG.warn("Rename operation affected {} rows: the catalog table's primary key assumption has been violated", (Object)updatedRecords);
        }
    }

    public static boolean databaseExists(JdbcClientPool connections, String storeKey, String databaseName) {
        if (JdbcUtils.exists(connections, GET_DATABASE_SQL, storeKey, databaseName)) {
            return true;
        }
        return JdbcUtils.exists(connections, GET_DATABASE_PROPERTIES_SQL, storeKey, databaseName);
    }

    public static boolean tableExists(JdbcClientPool connections, String storeKey, String databaseName, String tableName) {
        return JdbcUtils.exists(connections, GET_TABLE_SQL, storeKey, databaseName, tableName);
    }

    private static boolean exists(JdbcClientPool connections, String sql, String ... args2) {
        try {
            return (Boolean)connections.run(conn -> {
                try (PreparedStatement preparedStatement = conn.prepareStatement(sql);){
                    for (int index = 0; index < args2.length; ++index) {
                        preparedStatement.setString(index + 1, args2[index]);
                    }
                    try (ResultSet rs = preparedStatement.executeQuery();){
                        if (rs.next()) {
                            Boolean bl = true;
                            return bl;
                        }
                    }
                }
                return false;
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to execute exists query: %s", sql), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in SQL query", e);
        }
    }

    public static int execute(JdbcClientPool connections, String sql, String ... args2) {
        return JdbcUtils.execute((SQLException err) -> {}, connections, sql, args2);
    }

    public static int execute(Consumer<SQLException> sqlErrorHandler, JdbcClientPool connections, String sql, String ... args2) {
        try {
            return (Integer)connections.run(conn -> {
                try (PreparedStatement preparedStatement = conn.prepareStatement(sql);){
                    for (int pos = 0; pos < args2.length; ++pos) {
                        preparedStatement.setString(pos + 1, args2[pos]);
                    }
                    Integer n = preparedStatement.executeUpdate();
                    return n;
                }
            });
        }
        catch (SQLException e) {
            sqlErrorHandler.accept(e);
            throw new RuntimeException(String.format("Failed to execute: %s", sql), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted in SQL command", e);
        }
    }

    public static boolean insertProperties(JdbcClientPool connections, String storeKey, String databaseName, Map<String, String> properties) {
        String[] args2 = (String[])properties.entrySet().stream().flatMap(entry -> Stream.of(storeKey, databaseName, (String)entry.getKey(), (String)entry.getValue())).toArray(String[]::new);
        int insertedRecords = JdbcUtils.execute(connections, JdbcUtils.insertPropertiesStatement(properties.size()), args2);
        if (insertedRecords == properties.size()) {
            return true;
        }
        throw new IllegalStateException(String.format("Failed to insert: %d of %d succeeded", insertedRecords, properties.size()));
    }

    private static String insertPropertiesStatement(int size) {
        StringBuilder sqlStatement = new StringBuilder(INSERT_DATABASE_PROPERTIES_SQL);
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sqlStatement.append(", ");
            }
            sqlStatement.append(INSERT_PROPERTIES_VALUES_BASE);
        }
        return sqlStatement.toString();
    }

    public static boolean updateProperties(JdbcClientPool connections, String storeKey, String databaseName, Map<String, String> properties) {
        Stream caseArgs = properties.entrySet().stream().flatMap(entry -> Stream.of((String)entry.getKey(), (String)entry.getValue()));
        Stream<String> whereArgs = Stream.concat(Stream.of(storeKey, databaseName), properties.keySet().stream());
        String[] args2 = (String[])Stream.concat(caseArgs, whereArgs).toArray(String[]::new);
        int updatedRecords = JdbcUtils.execute(connections, JdbcUtils.updatePropertiesStatement(properties.size()), args2);
        if (updatedRecords == properties.size()) {
            return true;
        }
        throw new IllegalStateException(String.format("Failed to update: %d of %d succeeded", updatedRecords, properties.size()));
    }

    private static String updatePropertiesStatement(int size) {
        StringBuilder sqlStatement = new StringBuilder("UPDATE paimon_database_properties SET property_value = CASE");
        for (int i = 0; i < size; ++i) {
            sqlStatement.append(" WHEN property_key = ? THEN ?");
        }
        sqlStatement.append(" END WHERE catalog_key = ? AND database_name = ? AND property_key IN ");
        String values2 = String.join((CharSequence)",", Collections.nCopies(size, String.valueOf('?')));
        sqlStatement.append("(").append(values2).append(")");
        return sqlStatement.toString();
    }

    public static boolean deleteProperties(JdbcClientPool connections, String storeKey, String databaseName, Set<String> removeKeys) {
        String[] args2 = (String[])Stream.concat(Stream.of(storeKey, databaseName), removeKeys.stream()).toArray(String[]::new);
        int deleteRecords = JdbcUtils.execute(connections, JdbcUtils.deletePropertiesStatement(removeKeys), args2);
        if (deleteRecords > 0) {
            return true;
        }
        throw new IllegalStateException(String.format("Failed to delete: %d of %d succeeded", deleteRecords, removeKeys.size()));
    }

    public static void createDistributedLockTable(JdbcClientPool connections, Options options) throws SQLException, InterruptedException {
        DistributedLockDialectFactory.create(connections.getProtocol()).createTable(connections, options);
    }

    public static boolean acquire(JdbcClientPool connections, String lockId, long timeoutMillSeconds) throws SQLException, InterruptedException {
        JdbcDistributedLockDialect distributedLockDialect = DistributedLockDialectFactory.create(connections.getProtocol());
        int affectedRows = distributedLockDialect.tryReleaseTimedOutLock(connections, lockId);
        if (affectedRows > 0) {
            LOG.debug("Successfully cleared " + affectedRows + " lock records");
        }
        return distributedLockDialect.lockAcquire(connections, lockId, timeoutMillSeconds);
    }

    public static void release(JdbcClientPool connections, String lockId) throws SQLException, InterruptedException {
        DistributedLockDialectFactory.create(connections.getProtocol()).releaseLock(connections, lockId);
    }

    private static String deletePropertiesStatement(Set<String> properties) {
        StringBuilder sqlStatement = new StringBuilder(DELETE_DATABASE_PROPERTIES_SQL);
        String values2 = String.join((CharSequence)",", Collections.nCopies(properties.size(), String.valueOf('?')));
        sqlStatement.append("(").append(values2).append(")");
        return sqlStatement.toString();
    }
}

