/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.PartitionSettedRow;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.casting.CastedRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.PartitionInfo;
import org.apache.paimon.data.columnar.ColumnarRowIterator;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.reader.FileRecordIterator;
import org.apache.paimon.reader.FileRecordReader;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.ProjectedRow;

public class DataFileRecordReader
implements FileRecordReader<InternalRow> {
    private final FileRecordReader<InternalRow> reader;
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final PartitionInfo partitionInfo;
    @Nullable
    private final CastFieldGetter[] castMapping;

    public DataFileRecordReader(FormatReaderFactory readerFactory, FormatReaderFactory.Context context, @Nullable int[] indexMapping, @Nullable CastFieldGetter[] castMapping, @Nullable PartitionInfo partitionInfo) throws IOException {
        try {
            this.reader = readerFactory.createReader(context);
        }
        catch (Exception e) {
            FileUtils.checkExists(context.fileIO(), context.filePath());
            throw e;
        }
        this.indexMapping = indexMapping;
        this.partitionInfo = partitionInfo;
        this.castMapping = castMapping;
    }

    @Nullable
    public FileRecordIterator<InternalRow> readBatch() throws IOException {
        FileRecordIterator iterator2 = this.reader.readBatch();
        if (iterator2 == null) {
            return null;
        }
        if (iterator2 instanceof ColumnarRowIterator) {
            iterator2 = ((ColumnarRowIterator)iterator2).mapping(this.partitionInfo, this.indexMapping);
        } else {
            if (this.partitionInfo != null) {
                PartitionSettedRow partitionSettedRow = PartitionSettedRow.from((PartitionInfo)this.partitionInfo);
                iterator2 = iterator2.transform(arg_0 -> ((PartitionSettedRow)partitionSettedRow).replaceRow(arg_0));
            }
            if (this.indexMapping != null) {
                ProjectedRow projectedRow = ProjectedRow.from((int[])this.indexMapping);
                iterator2 = iterator2.transform(arg_0 -> ((ProjectedRow)projectedRow).replaceRow(arg_0));
            }
        }
        if (this.castMapping != null) {
            CastedRow castedRow = CastedRow.from((CastFieldGetter[])this.castMapping);
            iterator2 = iterator2.transform(arg_0 -> ((CastedRow)castedRow).replaceRow(arg_0));
        }
        return iterator2;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

