/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntPredicate;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.utils.Int2ShortHashMap;
import org.apache.paimon.utils.IntIterator;
import org.apache.paimon.utils.ListUtils;

public class PartitionIndex {
    public final Int2ShortHashMap hash2Bucket;
    public final Map<Integer, Long> nonFullBucketInformation;
    public final Set<Integer> totalBucketSet;
    public final List<Integer> totalBucketArray;
    private final long targetBucketRowNumber;
    public boolean accessed;
    public long lastAccessedCommitIdentifier;

    public PartitionIndex(Int2ShortHashMap hash2Bucket, Map<Integer, Long> bucketInformation, long targetBucketRowNumber) {
        this.hash2Bucket = hash2Bucket;
        this.nonFullBucketInformation = bucketInformation;
        this.totalBucketSet = new LinkedHashSet<Integer>(bucketInformation.keySet());
        this.totalBucketArray = new ArrayList<Integer>(this.totalBucketSet);
        this.targetBucketRowNumber = targetBucketRowNumber;
        this.lastAccessedCommitIdentifier = Long.MIN_VALUE;
        this.accessed = true;
    }

    public int assign(int hash, IntPredicate bucketFilter, int maxBucketsNum, int maxBucketId) {
        this.accessed = true;
        if (this.hash2Bucket.containsKey(hash)) {
            return this.hash2Bucket.get(hash);
        }
        Iterator<Map.Entry<Integer, Long>> iterator2 = this.nonFullBucketInformation.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Integer, Long> entry = iterator2.next();
            Integer bucket = entry.getKey();
            Long number = entry.getValue();
            if (number < this.targetBucketRowNumber) {
                entry.setValue(number + 1L);
                this.hash2Bucket.put(hash, (short)bucket.intValue());
                return bucket;
            }
            iterator2.remove();
        }
        if (-1 == maxBucketsNum || this.totalBucketSet.isEmpty() || maxBucketId < maxBucketsNum - 1) {
            for (int i = 0; i < Short.MAX_VALUE; ++i) {
                if (!bucketFilter.test(i) || this.totalBucketSet.contains(i)) continue;
                if (-1 != maxBucketsNum && i > maxBucketsNum - 1) break;
                this.nonFullBucketInformation.put(i, 1L);
                this.totalBucketSet.add(i);
                this.totalBucketArray.add(i);
                this.hash2Bucket.put(hash, (short)i);
                return i;
            }
            if (-1 == maxBucketsNum) {
                throw new RuntimeException(String.format("Too more bucket %s, you should increase target bucket row number %s.", maxBucketId, this.targetBucketRowNumber));
            }
        }
        int bucket = (Integer)ListUtils.pickRandomly(this.totalBucketArray);
        this.hash2Bucket.put(hash, (short)bucket);
        return bucket;
    }

    public static PartitionIndex loadIndex(IndexFileHandler indexFileHandler, BinaryRow partition, long targetBucketRowNumber, IntPredicate loadFilter, IntPredicate bucketFilter) {
        List<IndexManifestEntry> files = indexFileHandler.scanEntries("HASH", partition);
        Int2ShortHashMap.Builder mapBuilder = Int2ShortHashMap.builder();
        HashMap<Integer, Long> buckets = new HashMap<Integer, Long>();
        for (IndexManifestEntry file : files) {
            try {
                IntIterator iterator2 = indexFileHandler.readHashIndex(file.indexFile());
                Throwable throwable = null;
                try {
                    try {
                        while (true) {
                            int hash;
                            if (loadFilter.test(hash = iterator2.next())) {
                                mapBuilder.put(hash, (short)file.bucket());
                            }
                            if (!bucketFilter.test(file.bucket())) continue;
                            buckets.compute(file.bucket(), (bucket, number) -> number == null ? 1L : number + 1L);
                        }
                    }
                    catch (EOFException ignored) {
                        if (iterator2 == null) continue;
                        if (throwable != null) {
                            try {
                                iterator2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        iterator2.close();
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (iterator2 != null) {
                            if (throwable != null) {
                                try {
                                    iterator2.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                iterator2.close();
                            }
                        }
                        throw throwable4;
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new PartitionIndex(mapBuilder.build(), buckets, targetBucketRowNumber);
    }
}

