/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.manifest;

import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalMapSerializer;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.iceberg.manifest.IcebergDataFileMeta;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ObjectSerializer;

public class IcebergDataFileMetaSerializer
extends ObjectSerializer<IcebergDataFileMeta> {
    private static final long serialVersionUID = 1L;
    private final InternalRowSerializer partSerializer;
    private final InternalMapSerializer nullValueCountsSerializer;
    private final InternalMapSerializer lowerBoundsSerializer;
    private final InternalMapSerializer upperBoundsSerializer;

    public IcebergDataFileMetaSerializer(RowType partitionType) {
        super(IcebergDataFileMeta.schema(partitionType));
        this.partSerializer = new InternalRowSerializer(partitionType);
        this.nullValueCountsSerializer = new InternalMapSerializer((DataType)DataTypes.INT(), (DataType)DataTypes.BIGINT());
        this.lowerBoundsSerializer = new InternalMapSerializer((DataType)DataTypes.INT(), (DataType)DataTypes.BYTES());
        this.upperBoundsSerializer = new InternalMapSerializer((DataType)DataTypes.INT(), (DataType)DataTypes.BYTES());
    }

    @Override
    public InternalRow toRow(IcebergDataFileMeta file) {
        return GenericRow.of((Object[])new Object[]{file.content().id(), BinaryString.fromString((String)file.filePath()), BinaryString.fromString((String)file.fileFormat()), file.partition(), file.recordCount(), file.fileSizeInBytes(), file.nullValueCounts(), file.lowerBounds(), file.upperBounds()});
    }

    @Override
    public IcebergDataFileMeta fromRow(InternalRow row) {
        return new IcebergDataFileMeta(IcebergDataFileMeta.Content.fromId(row.getInt(0)), row.getString(1).toString(), row.getString(2).toString(), this.partSerializer.toBinaryRow(row.getRow(3, this.partSerializer.getArity())).copy(), row.getLong(4), row.getLong(5), this.nullValueCountsSerializer.copy(row.getMap(6)), this.lowerBoundsSerializer.copy(row.getMap(7)), this.upperBoundsSerializer.copy(row.getMap(8)));
    }
}

