/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.manifest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.iceberg.manifest.IcebergConversions;
import org.apache.paimon.iceberg.metadata.IcebergDataField;
import org.apache.paimon.iceberg.metadata.IcebergSchema;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;

public class IcebergDataFileMeta {
    private final Content content;
    private final String filePath;
    private final String fileFormat;
    private final BinaryRow partition;
    private final long recordCount;
    private final long fileSizeInBytes;
    private final InternalMap nullValueCounts;
    private final InternalMap lowerBounds;
    private final InternalMap upperBounds;
    private long schemaId = 0L;

    IcebergDataFileMeta(Content content, String filePath, String fileFormat, BinaryRow partition, long recordCount, long fileSizeInBytes, InternalMap nullValueCounts, InternalMap lowerBounds, InternalMap upperBounds) {
        this.content = content;
        this.filePath = filePath;
        this.fileFormat = fileFormat;
        this.partition = partition;
        this.recordCount = recordCount;
        this.fileSizeInBytes = fileSizeInBytes;
        this.nullValueCounts = nullValueCounts;
        this.lowerBounds = lowerBounds;
        this.upperBounds = upperBounds;
    }

    public static IcebergDataFileMeta create(Content content, String filePath, String fileFormat, BinaryRow partition, long recordCount, long fileSizeInBytes, IcebergSchema icebergSchema, SimpleStats stats, @Nullable List<String> statsColumns) {
        int i;
        int numFields = icebergSchema.fields().size();
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        if (statsColumns == null) {
            for (i = 0; i < numFields; ++i) {
                indexMap.put(icebergSchema.fields().get(i).name(), i);
            }
        } else {
            for (i = 0; i < statsColumns.size(); ++i) {
                indexMap.put(statsColumns.get(i), i);
            }
        }
        HashMap<Integer, Long> nullValueCounts = new HashMap<Integer, Long>();
        HashMap<Integer, byte[]> lowerBounds = new HashMap<Integer, byte[]>();
        HashMap<Integer, byte[]> upperBounds = new HashMap<Integer, byte[]>();
        for (int i2 = 0; i2 < numFields; ++i2) {
            IcebergDataField field = icebergSchema.fields().get(i2);
            if (!indexMap.containsKey(field.name())) continue;
            int idx = (Integer)indexMap.get(field.name());
            nullValueCounts.put(field.id(), stats.nullCounts().getLong(idx));
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter((DataType)field.dataType(), (int)idx);
            Object minValue = fieldGetter.getFieldOrNull((InternalRow)stats.minValues());
            Object maxValue = fieldGetter.getFieldOrNull((InternalRow)stats.maxValues());
            if (minValue == null || maxValue == null) continue;
            lowerBounds.put(field.id(), IcebergConversions.toByteBuffer(field.dataType(), minValue).array());
            upperBounds.put(field.id(), IcebergConversions.toByteBuffer(field.dataType(), maxValue).array());
        }
        return new IcebergDataFileMeta(content, filePath, fileFormat, partition, recordCount, fileSizeInBytes, (InternalMap)new GenericMap(nullValueCounts), (InternalMap)new GenericMap(lowerBounds), (InternalMap)new GenericMap(upperBounds));
    }

    public Content content() {
        return this.content;
    }

    public String filePath() {
        return this.filePath;
    }

    public String fileFormat() {
        return this.fileFormat;
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public long recordCount() {
        return this.recordCount;
    }

    public long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public InternalMap nullValueCounts() {
        return this.nullValueCounts;
    }

    public InternalMap lowerBounds() {
        return this.lowerBounds;
    }

    public InternalMap upperBounds() {
        return this.upperBounds;
    }

    public long schemaId() {
        return this.schemaId;
    }

    public IcebergDataFileMeta withSchemaId(long schemaId) {
        this.schemaId = schemaId;
        return this;
    }

    public static RowType schema(RowType partitionType) {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(134, "content", DataTypes.INT().notNull()));
        fields.add(new DataField(100, "file_path", DataTypes.STRING().notNull()));
        fields.add(new DataField(101, "file_format", DataTypes.STRING().notNull()));
        fields.add(new DataField(102, "partition", (DataType)partitionType.notNull()));
        fields.add(new DataField(103, "record_count", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(104, "file_size_in_bytes", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(110, "null_value_counts", (DataType)DataTypes.MAP((DataType)DataTypes.INT().notNull(), (DataType)DataTypes.BIGINT().notNull())));
        fields.add(new DataField(125, "lower_bounds", (DataType)DataTypes.MAP((DataType)DataTypes.INT().notNull(), (DataType)DataTypes.BYTES().notNull())));
        fields.add(new DataField(128, "upper_bounds", (DataType)DataTypes.MAP((DataType)DataTypes.INT().notNull(), (DataType)DataTypes.BYTES().notNull())));
        return new RowType(false, fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergDataFileMeta that = (IcebergDataFileMeta)o;
        return this.content == that.content && this.recordCount == that.recordCount && this.fileSizeInBytes == that.fileSizeInBytes && Objects.equals(this.filePath, that.filePath) && Objects.equals(this.fileFormat, that.fileFormat) && Objects.equals(this.partition, that.partition) && Objects.equals(this.nullValueCounts, that.nullValueCounts) && Objects.equals(this.lowerBounds, that.lowerBounds) && Objects.equals(this.upperBounds, that.upperBounds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.content, this.filePath, this.fileFormat, this.partition, this.recordCount, this.fileSizeInBytes, this.nullValueCounts, this.lowerBounds, this.upperBounds});
    }

    public static enum Content {
        DATA(0),
        POSITION_DELETES(1),
        EQUALITY_DELETES(2);

        private final int id;

        private Content(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static Content fromId(int id) {
            switch (id) {
                case 0: {
                    return DATA;
                }
                case 1: {
                    return POSITION_DELETES;
                }
                case 2: {
                    return EQUALITY_DELETES;
                }
            }
            throw new IllegalArgumentException("Unknown manifest content: " + id);
        }
    }
}

