/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.crosspartition;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.crosspartition.BucketAssigner;
import org.apache.paimon.crosspartition.DeleteExistingProcessor;
import org.apache.paimon.crosspartition.SkipNewExistingProcessor;
import org.apache.paimon.crosspartition.UseOldExistingProcessor;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.utils.ProjectToRowFunction;
import org.apache.paimon.utils.RowIterator;

public interface ExistingProcessor {
    public boolean processExists(InternalRow var1, BinaryRow var2, int var3);

    public void bulkLoadNewRecords(Function<SortOrder, RowIterator> var1, Function<InternalRow, BinaryRow> var2, Function<InternalRow, BinaryRow> var3, Function<BinaryRow, Integer> var4);

    public static void bulkLoadCollectFirst(BiConsumer<InternalRow, Integer> collector, RowIterator iterator2, Function<InternalRow, BinaryRow> extractPrimary, Function<InternalRow, BinaryRow> extractPartition, Function<BinaryRow, Integer> assignBucket) {
        InternalRow row;
        BinaryRow currentKey = null;
        while ((row = iterator2.next()) != null) {
            BinaryRow primaryKey = extractPrimary.apply(row);
            if (currentKey != null && currentKey.equals((Object)primaryKey)) continue;
            collector.accept(row, assignBucket.apply(extractPartition.apply(row)));
            currentKey = primaryKey.copy();
        }
    }

    public static ExistingProcessor create(CoreOptions.MergeEngine mergeEngine, ProjectToRowFunction setPartition, BucketAssigner bucketAssigner, BiConsumer<InternalRow, Integer> collector) {
        switch (mergeEngine) {
            case DEDUPLICATE: {
                return new DeleteExistingProcessor(setPartition, bucketAssigner, collector);
            }
            case PARTIAL_UPDATE: 
            case AGGREGATE: {
                return new UseOldExistingProcessor(setPartition, collector);
            }
            case FIRST_ROW: {
                return new SkipNewExistingProcessor(collector);
            }
        }
        throw new UnsupportedOperationException("Unsupported engine: " + mergeEngine);
    }

    public static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }
}

