/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@Public
public class Identifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_DATABASE_NAME = "database";
    private static final String FIELD_OBJECT_NAME = "object";
    public static final RowType SCHEMA = new RowType(false, Arrays.asList(new DataField(0, "_DATABASE", (DataType)DataTypes.STRING()), new DataField(1, "_OBJECT", (DataType)DataTypes.STRING())));
    public static final String UNKNOWN_DATABASE = "unknown";
    @JsonProperty(value="database")
    private final String database;
    @JsonProperty(value="object")
    private final String object;
    private transient String table;
    private transient String branch;
    private transient String systemTable;

    @JsonCreator
    public Identifier(@JsonProperty(value="database") String database, @JsonProperty(value="object") String object) {
        this.database = database;
        this.object = object;
    }

    public Identifier(String database, String table, @Nullable String branch) {
        this(database, table, branch, null);
    }

    public Identifier(String database, String table, @Nullable String branch, @Nullable String systemTable) {
        this.database = database;
        StringBuilder builder = new StringBuilder(table);
        if (branch != null && !"main".equalsIgnoreCase(branch)) {
            builder.append("$").append("branch_").append(branch);
        }
        if (systemTable != null) {
            builder.append("$").append(systemTable);
        }
        this.object = builder.toString();
        this.table = table;
        this.branch = branch;
        this.systemTable = systemTable;
    }

    @JsonGetter(value="database")
    public String getDatabaseName() {
        return this.database;
    }

    @JsonGetter(value="object")
    public String getObjectName() {
        return this.object;
    }

    @JsonIgnore
    public String getFullName() {
        return UNKNOWN_DATABASE.equals(this.database) ? this.object : String.format("%s.%s", this.database, this.object);
    }

    @JsonIgnore
    public String getTableName() {
        this.splitObjectName();
        return this.table;
    }

    @JsonIgnore
    @Nullable
    public String getBranchName() {
        this.splitObjectName();
        return this.branch;
    }

    @JsonIgnore
    public String getBranchNameOrDefault() {
        String branch = this.getBranchName();
        return branch == null ? "main" : branch;
    }

    @JsonIgnore
    @Nullable
    public String getSystemTableName() {
        this.splitObjectName();
        return this.systemTable;
    }

    @JsonIgnore
    public boolean isSystemTable() {
        return this.getSystemTableName() != null;
    }

    private void splitObjectName() {
        if (this.table != null) {
            return;
        }
        String[] splits = StringUtils.split((String)this.object, (String)"$", (int)-1, (boolean)true);
        if (splits.length == 1) {
            this.table = this.object;
            this.branch = null;
            this.systemTable = null;
        } else if (splits.length == 2) {
            this.table = splits[0];
            if (splits[1].startsWith("branch_")) {
                this.branch = splits[1].substring("branch_".length());
                this.systemTable = null;
            } else {
                this.branch = null;
                this.systemTable = splits[1];
            }
        } else if (splits.length == 3) {
            Preconditions.checkArgument((boolean)splits[1].startsWith("branch_"), (Object)("System table can only contain one '$' separator, but this is: " + this.object));
            this.table = splits[0];
            this.branch = splits[1].substring("branch_".length());
            this.systemTable = splits[2];
        } else {
            throw new IllegalArgumentException("Invalid object name: " + this.object);
        }
    }

    @JsonIgnore
    public String getEscapedFullName() {
        return this.getEscapedFullName('`');
    }

    @JsonIgnore
    public String getEscapedFullName(char escapeChar) {
        return String.format("%c%s%c.%c%s%c", Character.valueOf(escapeChar), this.database, Character.valueOf(escapeChar), Character.valueOf(escapeChar), this.object, Character.valueOf(escapeChar));
    }

    public static Identifier create(String db, String object) {
        return new Identifier(db, object);
    }

    public static Identifier fromString(String fullName) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)fullName) ? 1 : 0) != 0, (Object)"fullName cannot be null or empty");
        String[] paths = fullName.split("\\.");
        if (paths.length != 2) {
            throw new IllegalArgumentException(String.format("Cannot get splits from '%s' to get database and object", fullName));
        }
        return new Identifier(paths[0], paths[1]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.object, that.object);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.object);
    }

    public String toString() {
        return String.format("Identifier{database='%s', object='%s'}", this.database, this.object);
    }
}

