/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.PagedList;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.Database;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.PropertyChange;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.partition.PartitionStatistics;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.table.Instant;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.TableSnapshot;
import org.apache.paimon.view.View;
import org.apache.paimon.view.ViewChange;

@Public
public interface Catalog
extends AutoCloseable {
    public static final String SYSTEM_TABLE_SPLITTER = "$";
    public static final String SYSTEM_DATABASE_NAME = "sys";
    public static final String SYSTEM_BRANCH_PREFIX = "branch_";
    public static final String COMMENT_PROP = "comment";
    public static final String OWNER_PROP = "owner";
    public static final String DEFAULT_DATABASE = "default";
    public static final String DB_SUFFIX = ".db";
    public static final String DB_LOCATION_PROP = "location";
    public static final String TABLE_DEFAULT_OPTION_PREFIX = "table-default.";
    public static final String NUM_ROWS_PROP = "numRows";
    public static final String NUM_FILES_PROP = "numFiles";
    public static final String TOTAL_SIZE_PROP = "totalSize";
    public static final String LAST_UPDATE_TIME_PROP = "lastUpdateTime";

    public List<String> listDatabases();

    public PagedList<String> listDatabasesPaged(@Nullable Integer var1, @Nullable String var2);

    default public void createDatabase(String name, boolean ignoreIfExists) throws DatabaseAlreadyExistException {
        this.createDatabase(name, ignoreIfExists, Collections.emptyMap());
    }

    public void createDatabase(String var1, boolean var2, Map<String, String> var3) throws DatabaseAlreadyExistException;

    public Database getDatabase(String var1) throws DatabaseNotExistException;

    public void dropDatabase(String var1, boolean var2, boolean var3) throws DatabaseNotExistException, DatabaseNotEmptyException;

    public void alterDatabase(String var1, List<PropertyChange> var2, boolean var3) throws DatabaseNotExistException;

    public Table getTable(Identifier var1) throws TableNotExistException;

    public List<String> listTables(String var1) throws DatabaseNotExistException;

    public PagedList<String> listTablesPaged(String var1, @Nullable Integer var2, @Nullable String var3) throws DatabaseNotExistException;

    public PagedList<Table> listTableDetailsPaged(String var1, @Nullable Integer var2, @Nullable String var3) throws DatabaseNotExistException;

    public void dropTable(Identifier var1, boolean var2) throws TableNotExistException;

    public void createTable(Identifier var1, Schema var2, boolean var3) throws TableAlreadyExistException, DatabaseNotExistException;

    public void renameTable(Identifier var1, Identifier var2, boolean var3) throws TableNotExistException, TableAlreadyExistException;

    public void alterTable(Identifier var1, List<SchemaChange> var2, boolean var3) throws TableNotExistException, ColumnAlreadyExistException, ColumnNotExistException;

    default public void invalidateTable(Identifier identifier) {
    }

    default public void alterTable(Identifier identifier, SchemaChange change, boolean ignoreIfNotExists) throws TableNotExistException, ColumnAlreadyExistException, ColumnNotExistException {
        this.alterTable(identifier, Collections.singletonList(change), ignoreIfNotExists);
    }

    public void markDonePartitions(Identifier var1, List<Map<String, String>> var2) throws TableNotExistException;

    public List<Partition> listPartitions(Identifier var1) throws TableNotExistException;

    public PagedList<Partition> listPartitionsPaged(Identifier var1, @Nullable Integer var2, @Nullable String var3) throws TableNotExistException;

    default public View getView(Identifier identifier) throws ViewNotExistException {
        throw new ViewNotExistException(identifier);
    }

    default public void dropView(Identifier identifier, boolean ignoreIfNotExists) throws ViewNotExistException {
        throw new UnsupportedOperationException();
    }

    default public void createView(Identifier identifier, View view, boolean ignoreIfExists) throws ViewAlreadyExistException, DatabaseNotExistException {
        throw new UnsupportedOperationException();
    }

    default public List<String> listViews(String databaseName) throws DatabaseNotExistException {
        return Collections.emptyList();
    }

    default public PagedList<String> listViewsPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken) throws DatabaseNotExistException {
        return new PagedList(this.listViews(databaseName), null);
    }

    default public PagedList<View> listViewDetailsPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken) throws DatabaseNotExistException {
        return new PagedList(Collections.emptyList(), null);
    }

    default public void renameView(Identifier fromView, Identifier toView, boolean ignoreIfNotExists) throws ViewNotExistException, ViewAlreadyExistException {
        throw new UnsupportedOperationException();
    }

    default public void alterView(Identifier view, List<ViewChange> viewChanges, boolean ignoreIfNotExists) throws ViewNotExistException, DialectAlreadyExistException, DialectNotExistException {
        throw new UnsupportedOperationException();
    }

    default public void repairCatalog() {
        throw new UnsupportedOperationException();
    }

    default public void repairDatabase(String databaseName) {
        throw new UnsupportedOperationException();
    }

    default public void repairTable(Identifier identifier) throws TableNotExistException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsListObjectsPaged();

    public boolean supportsVersionManagement();

    public boolean commitSnapshot(Identifier var1, Snapshot var2, List<PartitionStatistics> var3) throws TableNotExistException;

    public Optional<TableSnapshot> loadSnapshot(Identifier var1) throws TableNotExistException;

    public void rollbackTo(Identifier var1, Instant var2) throws TableNotExistException;

    public void createBranch(Identifier var1, String var2, @Nullable String var3) throws TableNotExistException, BranchAlreadyExistException, TagNotExistException;

    public void dropBranch(Identifier var1, String var2) throws BranchNotExistException;

    public void fastForward(Identifier var1, String var2) throws BranchNotExistException;

    public List<String> listBranches(Identifier var1) throws TableNotExistException;

    public void createPartitions(Identifier var1, List<Map<String, String>> var2) throws TableNotExistException;

    public void dropPartitions(Identifier var1, List<Map<String, String>> var2) throws TableNotExistException;

    public void alterPartitions(Identifier var1, List<PartitionStatistics> var2) throws TableNotExistException;

    public Map<String, String> options();

    public CatalogLoader catalogLoader();

    public boolean caseSensitive();

    public static class DialectNotExistException
    extends Exception {
        private static final String MSG = "Dialect %s in view %s doesn't exist.";
        private final Identifier identifier;
        private final String dialect;

        public DialectNotExistException(Identifier identifier, String dialect) {
            this(identifier, dialect, null);
        }

        public DialectNotExistException(Identifier identifier, String dialect, Throwable cause) {
            super(String.format(MSG, dialect, identifier.getFullName()), cause);
            this.identifier = identifier;
            this.dialect = dialect;
        }

        public Identifier identifier() {
            return this.identifier;
        }

        public String dialect() {
            return this.dialect;
        }
    }

    public static class TagNotExistException
    extends Exception {
        private static final String MSG = "Tag %s in table %s doesn't exist.";
        private final Identifier identifier;
        private final String tag;

        public TagNotExistException(Identifier identifier, String tag) {
            this(identifier, tag, null);
        }

        public TagNotExistException(Identifier identifier, String tag, Throwable cause) {
            super(String.format(MSG, tag, identifier.getFullName()), cause);
            this.identifier = identifier;
            this.tag = tag;
        }

        public Identifier identifier() {
            return this.identifier;
        }

        public String tag() {
            return this.tag;
        }
    }

    public static class BranchNotExistException
    extends Exception {
        private static final String MSG = "Branch %s in table %s doesn't exist.";
        private final Identifier identifier;
        private final String branch;

        public BranchNotExistException(Identifier identifier, String branch) {
            this(identifier, branch, null);
        }

        public BranchNotExistException(Identifier identifier, String branch, Throwable cause) {
            super(String.format(MSG, branch, identifier.getFullName()), cause);
            this.identifier = identifier;
            this.branch = branch;
        }

        public Identifier identifier() {
            return this.identifier;
        }

        public String branch() {
            return this.branch;
        }
    }

    public static class BranchAlreadyExistException
    extends Exception {
        private static final String MSG = "Branch %s in table %s already exists.";
        private final Identifier identifier;
        private final String branch;

        public BranchAlreadyExistException(Identifier identifier, String branch) {
            this(identifier, branch, null);
        }

        public BranchAlreadyExistException(Identifier identifier, String branch, Throwable cause) {
            super(String.format(MSG, branch, identifier.getFullName()), cause);
            this.identifier = identifier;
            this.branch = branch;
        }

        public Identifier identifier() {
            return this.identifier;
        }

        public String branch() {
            return this.branch;
        }
    }

    public static class DialectAlreadyExistException
    extends Exception {
        private static final String MSG = "Dialect %s in view %s already exists.";
        private final Identifier identifier;
        private final String dialect;

        public DialectAlreadyExistException(Identifier identifier, String dialect) {
            this(identifier, dialect, null);
        }

        public DialectAlreadyExistException(Identifier identifier, String dialect, Throwable cause) {
            super(String.format(MSG, dialect, identifier.getFullName()), cause);
            this.identifier = identifier;
            this.dialect = dialect;
        }

        public Identifier identifier() {
            return this.identifier;
        }

        public String dialect() {
            return this.dialect;
        }
    }

    public static class ViewNotExistException
    extends Exception {
        private static final String MSG = "View %s does not exist.";
        private final Identifier identifier;

        public ViewNotExistException(Identifier identifier) {
            this(identifier, null);
        }

        public ViewNotExistException(Identifier identifier, Throwable cause) {
            super(String.format(MSG, identifier.getFullName()), cause);
            this.identifier = identifier;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }

    public static class ViewAlreadyExistException
    extends Exception {
        private static final String MSG = "View %s already exists.";
        private final Identifier identifier;

        public ViewAlreadyExistException(Identifier identifier) {
            this(identifier, null);
        }

        public ViewAlreadyExistException(Identifier identifier, Throwable cause) {
            super(String.format(MSG, identifier.getFullName()), cause);
            this.identifier = identifier;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }

    public static class ColumnNotExistException
    extends Exception {
        private static final String MSG = "Column %s does not exist in the %s table.";
        private final Identifier identifier;
        private final String column;

        public ColumnNotExistException(Identifier identifier, String column) {
            this(identifier, column, null);
        }

        public ColumnNotExistException(Identifier identifier, String column, Throwable cause) {
            super(String.format(MSG, column, identifier.getFullName()), cause);
            this.identifier = identifier;
            this.column = column;
        }

        public Identifier identifier() {
            return this.identifier;
        }

        public String column() {
            return this.column;
        }
    }

    public static class ColumnAlreadyExistException
    extends Exception {
        private static final String MSG = "Column %s already exists in the %s table.";
        private final Identifier identifier;
        private final String column;

        public ColumnAlreadyExistException(Identifier identifier, String column) {
            this(identifier, column, null);
        }

        public ColumnAlreadyExistException(Identifier identifier, String column, Throwable cause) {
            super(String.format(MSG, column, identifier.getFullName()), cause);
            this.identifier = identifier;
            this.column = column;
        }

        public Identifier identifier() {
            return this.identifier;
        }

        public String column() {
            return this.column;
        }
    }

    public static class TableNoPermissionException
    extends RuntimeException {
        private static final String MSG = "Table %s has no permission.";
        private final Identifier identifier;

        public TableNoPermissionException(Identifier identifier, Throwable cause) {
            super(String.format(MSG, identifier.getFullName()), cause);
            this.identifier = identifier;
        }

        public TableNoPermissionException(Identifier identifier) {
            this(identifier, null);
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }

    public static class TableNotExistException
    extends Exception {
        private static final String MSG = "Table %s does not exist.";
        private final Identifier identifier;

        public TableNotExistException(Identifier identifier) {
            this(identifier, null);
        }

        public TableNotExistException(Identifier identifier, Throwable cause) {
            super(String.format(MSG, identifier.getFullName()), cause);
            this.identifier = identifier;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }

    public static class TableAlreadyExistException
    extends Exception {
        private static final String MSG = "Table %s already exists.";
        private final Identifier identifier;

        public TableAlreadyExistException(Identifier identifier) {
            this(identifier, null);
        }

        public TableAlreadyExistException(Identifier identifier, Throwable cause) {
            super(String.format(MSG, identifier.getFullName()), cause);
            this.identifier = identifier;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }

    public static class DatabaseNoPermissionException
    extends RuntimeException {
        private static final String MSG = "Database %s has no permission.";
        private final String database;

        public DatabaseNoPermissionException(String database, Throwable cause) {
            super(String.format(MSG, database), cause);
            this.database = database;
        }

        public DatabaseNoPermissionException(String database) {
            this(database, null);
        }

        public String database() {
            return this.database;
        }
    }

    public static class ProcessSystemDatabaseException
    extends IllegalArgumentException {
        private static final String MSG = "Can't do operation on system database.";

        public ProcessSystemDatabaseException() {
            super(MSG);
        }
    }

    public static class DatabaseNotExistException
    extends Exception {
        private static final String MSG = "Database %s does not exist.";
        private final String database;

        public DatabaseNotExistException(String database, Throwable cause) {
            super(String.format(MSG, database), cause);
            this.database = database;
        }

        public DatabaseNotExistException(String database) {
            this(database, null);
        }

        public String database() {
            return this.database;
        }
    }

    public static class DatabaseAlreadyExistException
    extends Exception {
        private static final String MSG = "Database %s already exists.";
        private final String database;

        public DatabaseAlreadyExistException(String database, Throwable cause) {
            super(String.format(MSG, database), cause);
            this.database = database;
        }

        public DatabaseAlreadyExistException(String database) {
            this(database, null);
        }

        public String database() {
            return this.database;
        }
    }

    public static class DatabaseNotEmptyException
    extends Exception {
        private static final String MSG = "Database %s is not empty.";
        private final String database;

        public DatabaseNotEmptyException(String database, Throwable cause) {
            super(String.format(MSG, database), cause);
            this.database = database;
        }

        public DatabaseNotEmptyException(String database) {
            this(database, null);
        }

        public String database() {
            return this.database;
        }
    }
}

