/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.append;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.compact.CompactDeletionFile;
import org.apache.paimon.compact.CompactFutureManager;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.compact.CompactTask;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.operation.metrics.CompactionMetrics;
import org.apache.paimon.operation.metrics.MetricUtils;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketedAppendCompactManager
extends CompactFutureManager {
    private static final Logger LOG = LoggerFactory.getLogger(BucketedAppendCompactManager.class);
    private static final int FULL_COMPACT_MIN_FILE = 3;
    private final ExecutorService executor;
    private final DeletionVectorsMaintainer dvMaintainer;
    private final PriorityQueue<DataFileMeta> toCompact;
    private final int minFileNum;
    private final long targetFileSize;
    private final CompactRewriter rewriter;
    private List<DataFileMeta> compacting;
    @Nullable
    private final CompactionMetrics.Reporter metricsReporter;

    public BucketedAppendCompactManager(ExecutorService executor, List<DataFileMeta> restored, @Nullable DeletionVectorsMaintainer dvMaintainer, int minFileNum, long targetFileSize, CompactRewriter rewriter, @Nullable CompactionMetrics.Reporter metricsReporter) {
        this.executor = executor;
        this.dvMaintainer = dvMaintainer;
        this.toCompact = new PriorityQueue<DataFileMeta>(BucketedAppendCompactManager.fileComparator(false));
        this.toCompact.addAll(restored);
        this.minFileNum = minFileNum;
        this.targetFileSize = targetFileSize;
        this.rewriter = rewriter;
        this.metricsReporter = metricsReporter;
    }

    @Override
    public void triggerCompaction(boolean fullCompaction) {
        if (fullCompaction) {
            this.triggerFullCompaction();
        } else {
            this.triggerCompactionWithBestEffort();
        }
    }

    private void triggerFullCompaction() {
        Preconditions.checkState((this.taskFuture == null ? 1 : 0) != 0, (Object)"A compaction task is still running while the user forces a new compaction. This is unexpected.");
        if (this.toCompact.isEmpty() || this.dvMaintainer == null && this.toCompact.size() < 3) {
            return;
        }
        this.taskFuture = this.executor.submit(new FullCompactTask(this.dvMaintainer, this.toCompact, this.targetFileSize, this.rewriter, this.metricsReporter));
        this.recordCompactionsQueuedRequest();
        this.compacting = new ArrayList<DataFileMeta>(this.toCompact);
        this.toCompact.clear();
    }

    private void recordCompactionsQueuedRequest() {
        if (this.metricsReporter != null) {
            this.metricsReporter.increaseCompactionsQueuedCount();
        }
    }

    private void triggerCompactionWithBestEffort() {
        if (this.taskFuture != null) {
            return;
        }
        Optional<List<DataFileMeta>> picked = this.pickCompactBefore();
        if (picked.isPresent()) {
            this.compacting = picked.get();
            this.taskFuture = this.executor.submit(new AutoCompactTask(this.dvMaintainer, this.compacting, this.rewriter, this.metricsReporter));
            this.recordCompactionsQueuedRequest();
        }
    }

    @Override
    public boolean shouldWaitForLatestCompaction() {
        return false;
    }

    @Override
    public boolean shouldWaitForPreparingCheckpoint() {
        return false;
    }

    @Override
    public void addNewFile(DataFileMeta file) {
        this.toCompact.add(file);
    }

    public List<DataFileMeta> allFiles() {
        ArrayList<DataFileMeta> allFiles = new ArrayList<DataFileMeta>();
        if (this.compacting != null) {
            allFiles.addAll(this.compacting);
        }
        allFiles.addAll(this.toCompact);
        return allFiles;
    }

    @Override
    public Optional<CompactResult> getCompactionResult(boolean blocking) throws ExecutionException, InterruptedException {
        Optional<CompactResult> result = this.innerGetCompactionResult(blocking);
        if (result.isPresent()) {
            DataFileMeta lastFile;
            CompactResult compactResult = result.get();
            if (!compactResult.after().isEmpty() && (lastFile = compactResult.after().get(compactResult.after().size() - 1)).fileSize() < this.targetFileSize) {
                this.toCompact.add(lastFile);
            }
            this.compacting = null;
        }
        return result;
    }

    @VisibleForTesting
    Optional<List<DataFileMeta>> pickCompactBefore() {
        if (this.toCompact.isEmpty()) {
            return Optional.empty();
        }
        long totalFileSize = 0L;
        int fileNum = 0;
        LinkedList<DataFileMeta> candidates = new LinkedList<DataFileMeta>();
        while (!this.toCompact.isEmpty()) {
            DataFileMeta file = this.toCompact.poll();
            candidates.add(file);
            totalFileSize += file.fileSize();
            if (++fileNum >= this.minFileNum) {
                return Optional.of(candidates);
            }
            if (totalFileSize < this.targetFileSize) continue;
            DataFileMeta removed = (DataFileMeta)candidates.pollFirst();
            assert (removed != null);
            totalFileSize -= removed.fileSize();
            --fileNum;
        }
        this.toCompact.addAll(candidates);
        return Optional.empty();
    }

    @VisibleForTesting
    PriorityQueue<DataFileMeta> getToCompact() {
        return this.toCompact;
    }

    @Override
    public void close() throws IOException {
        if (this.metricsReporter != null) {
            MetricUtils.safeCall(this.metricsReporter::unregister, LOG);
        }
    }

    private static CompactResult compact(@Nullable DeletionVectorsMaintainer dvMaintainer, List<DataFileMeta> toCompact, CompactRewriter rewriter) throws Exception {
        List<DataFileMeta> rewrite = rewriter.rewrite(toCompact);
        CompactResult result = BucketedAppendCompactManager.result(toCompact, rewrite);
        if (dvMaintainer != null) {
            toCompact.forEach(f -> dvMaintainer.removeDeletionVectorOf(f.fileName()));
            result.setDeletionFile(CompactDeletionFile.generateFiles(dvMaintainer));
        }
        return result;
    }

    private static CompactResult result(List<DataFileMeta> before, List<DataFileMeta> after) {
        return new CompactResult(before, after);
    }

    public static Comparator<DataFileMeta> fileComparator(boolean ignoreOverlap) {
        return (o1, o2) -> {
            if (o1 == o2) {
                return 0;
            }
            if (!ignoreOverlap && BucketedAppendCompactManager.isOverlap(o1, o2)) {
                LOG.warn(String.format("There should no overlap in append files, but Range1(%s, %s), Range2(%s, %s), check if you have multiple write jobs.", o1.minSequenceNumber(), o1.maxSequenceNumber(), o2.minSequenceNumber(), o2.maxSequenceNumber()));
            }
            return Long.compare(o1.minSequenceNumber(), o2.minSequenceNumber());
        };
    }

    private static boolean isOverlap(DataFileMeta o1, DataFileMeta o2) {
        return o2.minSequenceNumber() <= o1.maxSequenceNumber() && o2.maxSequenceNumber() >= o1.minSequenceNumber();
    }

    public static interface CompactRewriter {
        public List<DataFileMeta> rewrite(List<DataFileMeta> var1) throws Exception;
    }

    public static class AutoCompactTask
    extends CompactTask {
        private final DeletionVectorsMaintainer dvMaintainer;
        private final List<DataFileMeta> toCompact;
        private final CompactRewriter rewriter;

        public AutoCompactTask(DeletionVectorsMaintainer dvMaintainer, List<DataFileMeta> toCompact, CompactRewriter rewriter, @Nullable CompactionMetrics.Reporter metricsReporter) {
            super(metricsReporter);
            this.dvMaintainer = dvMaintainer;
            this.toCompact = toCompact;
            this.rewriter = rewriter;
        }

        @Override
        protected CompactResult doCompact() throws Exception {
            return BucketedAppendCompactManager.compact(this.dvMaintainer, this.toCompact, this.rewriter);
        }
    }

    public static class FullCompactTask
    extends CompactTask {
        private final DeletionVectorsMaintainer dvMaintainer;
        private final LinkedList<DataFileMeta> toCompact;
        private final long targetFileSize;
        private final CompactRewriter rewriter;

        public FullCompactTask(DeletionVectorsMaintainer dvMaintainer, Collection<DataFileMeta> inputs, long targetFileSize, CompactRewriter rewriter, @Nullable CompactionMetrics.Reporter metricsReporter) {
            super(metricsReporter);
            this.dvMaintainer = dvMaintainer;
            this.toCompact = new LinkedList<DataFileMeta>(inputs);
            this.targetFileSize = targetFileSize;
            this.rewriter = rewriter;
        }

        @Override
        protected CompactResult doCompact() throws Exception {
            DataFileMeta file;
            while (!this.toCompact.isEmpty() && (file = this.toCompact.peekFirst()).fileSize() >= this.targetFileSize && !this.hasDeletionFile(file)) {
                this.toCompact.poll();
            }
            if (this.dvMaintainer != null) {
                return BucketedAppendCompactManager.compact(this.dvMaintainer, this.toCompact, this.rewriter);
            }
            int big = 0;
            int small = 0;
            for (DataFileMeta file2 : this.toCompact) {
                if (file2.fileSize() >= this.targetFileSize) {
                    ++big;
                    continue;
                }
                ++small;
            }
            if (small > big && this.toCompact.size() >= 3) {
                return BucketedAppendCompactManager.compact(null, this.toCompact, this.rewriter);
            }
            return BucketedAppendCompactManager.result(Collections.emptyList(), Collections.emptyList());
        }

        private boolean hasDeletionFile(DataFileMeta file) {
            return this.dvMaintainer != null && this.dvMaintainer.deletionVectorOf(file.fileName()).isPresent();
        }
    }
}

