/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.paimon.data.AbstractPagedInputView;
import org.apache.paimon.data.AbstractPagedOutputView;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.RandomAccessInputView;
import org.apache.paimon.data.Segments;
import org.apache.paimon.data.SimpleCollectingOutputView;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentSource;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.SegmentsCache;

public class ObjectsCache<K, V> {
    private final SegmentsCache<K> cache;
    private final ObjectSerializer<V> serializer;
    private final InternalRowSerializer rowSerializer;
    private final Function<K, CloseableIterator<InternalRow>> reader;

    public ObjectsCache(SegmentsCache<K> cache, ObjectSerializer<V> serializer, Function<K, CloseableIterator<InternalRow>> reader) {
        this.cache = cache;
        this.serializer = serializer;
        this.rowSerializer = new InternalRowSerializer(serializer.fieldTypes());
        this.reader = reader;
    }

    public List<V> read(K key, Filter<InternalRow> loadFilter, Filter<InternalRow> readFilter) throws IOException {
        Segments segments = this.cache.getSegments(key, k -> this.readSegments(k, loadFilter));
        ArrayList<V> entries = new ArrayList<V>();
        RandomAccessInputView view = new RandomAccessInputView(segments.segments(), this.cache.pageSize(), segments.limitInLastSegment());
        BinaryRow binaryRow = new BinaryRow(this.rowSerializer.getArity());
        try {
            while (true) {
                this.rowSerializer.mapFromPages((InternalRow)binaryRow, (AbstractPagedInputView)view);
                if (!readFilter.test((Object)binaryRow)) continue;
                entries.add(this.serializer.fromRow((InternalRow)binaryRow));
            }
        }
        catch (EOFException e) {
            return entries;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Segments readSegments(K key, Filter<InternalRow> loadFilter) {
        try (CloseableIterator<InternalRow> iterator = this.reader.apply(key);){
            ArrayList segments = new ArrayList();
            MemorySegmentSource segmentSource = () -> MemorySegment.allocateHeapMemory((int)this.cache.pageSize());
            SimpleCollectingOutputView output = new SimpleCollectingOutputView(segments, segmentSource, this.cache.pageSize());
            while (iterator.hasNext()) {
                InternalRow row = (InternalRow)iterator.next();
                if (!loadFilter.test((Object)row)) continue;
                this.rowSerializer.serializeToPages(row, (AbstractPagedOutputView)output);
            }
            Segments segments2 = new Segments(segments, output.getCurrentPositionInSegment());
            return segments2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

