/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.RowDataPartitionComputer;

@ThreadSafe
public class FileStorePathFactory {
    public static final ConfigOption<String> PARTITION_DEFAULT_NAME = ConfigOptions.key((String)"partition.default-name").stringType().defaultValue((Object)"__DEFAULT_PARTITION__").withDescription("The default partition name in case the dynamic partition column value is null/empty string.");
    private final Path root;
    private final String uuid;
    private final RowDataPartitionComputer partitionComputer;
    private final String formatIdentifier;
    private final AtomicInteger manifestFileCount;
    private final AtomicInteger manifestListCount;
    private final AtomicInteger indexManifestCount;
    private final AtomicInteger indexFileCount;

    public FileStorePathFactory(Path root) {
        this(root, RowType.builder().build(), (String)PARTITION_DEFAULT_NAME.defaultValue(), ((CoreOptions.FileFormatType)CoreOptions.FILE_FORMAT.defaultValue()).toString());
    }

    public FileStorePathFactory(Path root, RowType partitionType, String defaultPartValue, String formatIdentifier) {
        this.root = root;
        this.uuid = UUID.randomUUID().toString();
        this.partitionComputer = FileStorePathFactory.getPartitionComputer(partitionType, defaultPartValue);
        this.formatIdentifier = formatIdentifier;
        this.manifestFileCount = new AtomicInteger(0);
        this.manifestListCount = new AtomicInteger(0);
        this.indexManifestCount = new AtomicInteger(0);
        this.indexFileCount = new AtomicInteger(0);
    }

    public Path root() {
        return this.root;
    }

    @VisibleForTesting
    public static RowDataPartitionComputer getPartitionComputer(RowType partitionType, String defaultPartValue) {
        String[] partitionColumns = partitionType.getFieldNames().toArray(new String[0]);
        return new RowDataPartitionComputer(defaultPartValue, partitionType, partitionColumns);
    }

    public Path newManifestFile() {
        return new Path(this.root + "/manifest/manifest-" + this.uuid + "-" + this.manifestFileCount.getAndIncrement());
    }

    public Path newManifestList() {
        return new Path(this.root + "/manifest/manifest-list-" + this.uuid + "-" + this.manifestListCount.getAndIncrement());
    }

    public Path toManifestFilePath(String manifestFileName) {
        return new Path(this.root + "/manifest/" + manifestFileName);
    }

    public Path toManifestListPath(String manifestListName) {
        return new Path(this.root + "/manifest/" + manifestListName);
    }

    public DataFilePathFactory createDataFilePathFactory(BinaryRow partition, int bucket) {
        return new DataFilePathFactory(this.root, this.getPartitionString(partition), bucket, this.formatIdentifier);
    }

    public Path bucketPath(BinaryRow partition, int bucket) {
        return DataFilePathFactory.bucketPath(this.root, this.getPartitionString(partition), bucket);
    }

    public String getPartitionString(BinaryRow partition) {
        return PartitionPathUtils.generatePartitionPath(this.partitionComputer.generatePartValues((InternalRow)Preconditions.checkNotNull((Object)partition, (String)"Partition row data is null. This is unexpected.")));
    }

    public List<Path> getHierarchicalPartitionPath(BinaryRow partition) {
        return PartitionPathUtils.generateHierarchicalPartitionPaths(this.partitionComputer.generatePartValues((InternalRow)Preconditions.checkNotNull((Object)partition, (String)"Partition binary row is null. This is unexpected."))).stream().map(p -> new Path(this.root + "/" + p)).collect(Collectors.toList());
    }

    @VisibleForTesting
    public String uuid() {
        return this.uuid;
    }

    public PathFactory manifestFileFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return FileStorePathFactory.this.newManifestFile();
            }

            @Override
            public Path toPath(String fileName) {
                return FileStorePathFactory.this.toManifestFilePath(fileName);
            }
        };
    }

    public PathFactory manifestListFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return FileStorePathFactory.this.newManifestList();
            }

            @Override
            public Path toPath(String fileName) {
                return FileStorePathFactory.this.toManifestListPath(fileName);
            }
        };
    }

    public PathFactory indexManifestFileFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return new Path(FileStorePathFactory.this.root + "/manifest/index-manifest-" + FileStorePathFactory.this.uuid + "-" + FileStorePathFactory.this.indexManifestCount.getAndIncrement());
            }

            @Override
            public Path toPath(String fileName) {
                return new Path(FileStorePathFactory.this.root + "/manifest/" + fileName);
            }
        };
    }

    public PathFactory indexFileFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return new Path(FileStorePathFactory.this.root + "/index/index-" + FileStorePathFactory.this.uuid + "-" + FileStorePathFactory.this.indexFileCount.getAndIncrement());
            }

            @Override
            public Path toPath(String fileName) {
                return new Path(FileStorePathFactory.this.root + "/index/" + fileName);
            }
        };
    }
}

