/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tag;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.utils.Preconditions;

public interface TagPeriodHandler {
    public static final DateTimeFormatter HOUR_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NORMAL).appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NORMAL).toFormatter().withResolverStyle(ResolverStyle.LENIENT);
    public static final DateTimeFormatter DAY_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NORMAL).toFormatter().withResolverStyle(ResolverStyle.LENIENT);

    public void validateDelay(Duration var1);

    public LocalDateTime tagToTime(String var1);

    public LocalDateTime normalizeToPreviousTag(LocalDateTime var1);

    public String timeToTag(LocalDateTime var1);

    public LocalDateTime nextTagTime(LocalDateTime var1);

    public static TagPeriodHandler create(CoreOptions options) {
        switch (options.tagCreationPeriod()) {
            case DAILY: {
                return new DailyTagPeriodHandler();
            }
            case HOURLY: {
                return new HourlyTagPeriodHandler();
            }
            case TWO_HOURS: {
                return new TwoHoursTagPeriodHandler();
            }
        }
        throw new UnsupportedOperationException("Unsupported " + options.tagCreationPeriod());
    }

    public static class TwoHoursTagPeriodHandler
    extends BaseTagPeriodHandler {
        static final Duration ONE_PERIOD = Duration.ofHours(2L);

        @Override
        protected Duration onePeriod() {
            return ONE_PERIOD;
        }

        @Override
        protected DateTimeFormatter formatter() {
            return HOUR_FORMATTER;
        }
    }

    public static class DailyTagPeriodHandler
    extends BaseTagPeriodHandler {
        static final Duration ONE_PERIOD = Duration.ofDays(1L);

        @Override
        protected Duration onePeriod() {
            return ONE_PERIOD;
        }

        @Override
        protected DateTimeFormatter formatter() {
            return DAY_FORMATTER;
        }

        @Override
        public LocalDateTime tagToTime(String tag) {
            tag = tag.split(" ")[0];
            return LocalDate.parse(tag, this.formatter()).atStartOfDay();
        }
    }

    public static class HourlyTagPeriodHandler
    extends BaseTagPeriodHandler {
        static final Duration ONE_PERIOD = Duration.ofHours(1L);

        @Override
        protected Duration onePeriod() {
            return ONE_PERIOD;
        }

        @Override
        protected DateTimeFormatter formatter() {
            return HOUR_FORMATTER;
        }
    }

    public static abstract class BaseTagPeriodHandler
    implements TagPeriodHandler {
        protected abstract Duration onePeriod();

        protected abstract DateTimeFormatter formatter();

        @Override
        public void validateDelay(Duration delay) {
            Preconditions.checkArgument((this.onePeriod().compareTo(delay) > 0 ? 1 : 0) != 0);
        }

        @Override
        public LocalDateTime tagToTime(String tag) {
            return LocalDateTime.parse(tag, this.formatter());
        }

        @Override
        public LocalDateTime normalizeToPreviousTag(LocalDateTime time) {
            long mills = Timestamp.fromLocalDateTime((LocalDateTime)time).getMillisecond();
            long periodMills = this.onePeriod().toMillis();
            LocalDateTime normalized = Timestamp.fromEpochMillis((long)(mills / periodMills * periodMills)).toLocalDateTime();
            return normalized.minus(this.onePeriod());
        }

        @Override
        public String timeToTag(LocalDateTime time) {
            return time.format(this.formatter());
        }

        @Override
        public LocalDateTime nextTagTime(LocalDateTime time) {
            return time.plus(this.onePeriod());
        }
    }
}

