/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tag;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.operation.TagDeletion;
import org.apache.paimon.shade.guava30.com.google.common.base.MoreObjects;
import org.apache.paimon.tag.TagPeriodHandler;
import org.apache.paimon.tag.TagTimeExtractor;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class TagAutoCreation {
    private final SnapshotManager snapshotManager;
    private final TagManager tagManager;
    private final TagDeletion tagDeletion;
    private final TagTimeExtractor timeExtractor;
    private final TagPeriodHandler periodHandler;
    private final Duration delay;
    private final Integer numRetainedMax;
    private LocalDateTime nextTag;
    private long nextSnapshot;

    private TagAutoCreation(SnapshotManager snapshotManager, TagManager tagManager, TagDeletion tagDeletion, TagTimeExtractor timeExtractor, TagPeriodHandler periodHandler, Duration delay, Integer numRetainedMax) {
        this.snapshotManager = snapshotManager;
        this.tagManager = tagManager;
        this.tagDeletion = tagDeletion;
        this.timeExtractor = timeExtractor;
        this.periodHandler = periodHandler;
        this.delay = delay;
        this.numRetainedMax = numRetainedMax;
        this.periodHandler.validateDelay(delay);
        SortedMap<Snapshot, String> tags = tagManager.tags();
        if (tags.isEmpty()) {
            this.nextSnapshot = (Long)MoreObjects.firstNonNull((Object)snapshotManager.earliestSnapshotId(), (Object)1L);
        } else {
            Snapshot lastTag = tags.lastKey();
            this.nextSnapshot = lastTag.id() + 1L;
            LocalDateTime time = periodHandler.tagToTime((String)tags.get(lastTag));
            this.nextTag = periodHandler.nextTagTime(time);
        }
    }

    public boolean forceCreatingSnapshot() {
        return this.timeExtractor instanceof TagTimeExtractor.ProcessTimeExtractor && (this.nextTag == null || this.isAfterOrEqual(LocalDateTime.now().minus(this.delay), this.periodHandler.nextTagTime(this.nextTag)));
    }

    public void run() {
        while (true) {
            if (this.snapshotManager.snapshotExists(this.nextSnapshot)) {
                this.tryToTag(this.snapshotManager.snapshot(this.nextSnapshot));
                ++this.nextSnapshot;
                continue;
            }
            Long earliest = this.snapshotManager.earliestSnapshotId();
            if (earliest == null || earliest <= this.nextSnapshot) break;
            this.nextSnapshot = earliest;
        }
    }

    private void tryToTag(Snapshot snapshot) {
        Optional<LocalDateTime> timeOptional = this.timeExtractor.extract(snapshot.timeMillis(), snapshot.watermark());
        if (!timeOptional.isPresent()) {
            return;
        }
        LocalDateTime time = timeOptional.get();
        if (this.nextTag == null || this.isAfterOrEqual(time.minus(this.delay), this.periodHandler.nextTagTime(this.nextTag))) {
            SortedMap<Snapshot, String> tags;
            LocalDateTime thisTag = this.periodHandler.normalizeToPreviousTag(time);
            String tagName = this.periodHandler.timeToTag(thisTag);
            this.tagManager.createTag(snapshot, tagName);
            this.nextTag = this.periodHandler.nextTagTime(thisTag);
            if (this.numRetainedMax != null && (tags = this.tagManager.tags()).size() > this.numRetainedMax) {
                int toDelete = tags.size() - this.numRetainedMax;
                int i = 0;
                for (String tag : tags.values()) {
                    this.tagManager.deleteTag(tag, this.tagDeletion, this.snapshotManager);
                    if (++i != toDelete) continue;
                    break;
                }
            }
        }
    }

    private boolean isAfterOrEqual(LocalDateTime t1, LocalDateTime t2) {
        return t1.isAfter(t2) || t1.isEqual(t2);
    }

    @Nullable
    public static TagAutoCreation create(CoreOptions options, SnapshotManager snapshotManager, TagManager tagManager, TagDeletion tagDeletion) {
        TagTimeExtractor extractor = TagTimeExtractor.createForAutoTag(options);
        if (extractor == null) {
            return null;
        }
        return new TagAutoCreation(snapshotManager, tagManager, tagDeletion, extractor, TagPeriodHandler.create(options), options.tagCreationDelay(), options.tagNumRetainedMax());
    }
}

