/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.io.IOException;
import java.util.Optional;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.operation.DefaultValueAssigner;
import org.apache.paimon.operation.FileStoreRead;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateProjectionConverter;
import org.apache.paimon.predicate.PredicateVisitor;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.utils.Projection;

public abstract class AbstractDataTableRead<T>
implements InnerTableRead {
    private final FileStoreRead<T> fileStoreRead;
    private final DefaultValueAssigner defaultValueAssigner;
    private int[][] projection;
    private boolean executeFilter = false;
    private Predicate predicate;

    public AbstractDataTableRead(FileStoreRead<T> fileStoreRead, TableSchema schema) {
        this.fileStoreRead = fileStoreRead;
        this.defaultValueAssigner = schema == null ? null : DefaultValueAssigner.create(schema);
    }

    public abstract void projection(int[][] var1);

    public abstract RecordReader<InternalRow> reader(Split var1) throws IOException;

    @Override
    public TableRead withIOManager(IOManager ioManager) {
        return this;
    }

    @Override
    public final InnerTableRead withFilter(Predicate predicate) {
        this.predicate = predicate;
        if (this.defaultValueAssigner != null) {
            predicate = this.defaultValueAssigner.handlePredicate(predicate);
        }
        this.fileStoreRead.withFilter(predicate);
        return this;
    }

    @Override
    public TableRead executeFilter() {
        this.executeFilter = true;
        return this;
    }

    @Override
    public final InnerTableRead withProjection(int[][] projection) {
        this.projection = projection;
        this.defaultValueAssigner.handleProject(projection);
        this.projection(projection);
        return this;
    }

    @Override
    public final RecordReader<InternalRow> createReader(Split split) throws IOException {
        RecordReader<InternalRow> reader = this.reader(split);
        if (this.defaultValueAssigner != null) {
            reader = this.defaultValueAssigner.assignFieldsDefaultValue(reader);
        }
        if (this.executeFilter) {
            reader = this.executeFilter(reader);
        }
        return reader;
    }

    private RecordReader<InternalRow> executeFilter(RecordReader<InternalRow> reader) {
        if (this.predicate == null) {
            return reader;
        }
        Predicate predicate = this.predicate;
        if (this.projection != null) {
            Optional optional = (Optional)predicate.visit((PredicateVisitor)new PredicateProjectionConverter(Projection.of((int[][])this.projection).toTopLevelIndexes()));
            if (!optional.isPresent()) {
                return reader;
            }
            predicate = (Predicate)optional.get();
        }
        Predicate finalFilter = predicate;
        return reader.filter(arg_0 -> ((Predicate)finalFilter).test(arg_0));
    }
}

