/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.memory.MemoryPoolFactory;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.operation.AbstractFileStoreWrite;
import org.apache.paimon.operation.FileStoreWrite;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.InnerTableWrite;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;
import org.apache.paimon.table.sink.SinkRecord;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.Restorable;

public class TableWriteImpl<T>
implements InnerTableWrite,
Restorable<List<AbstractFileStoreWrite.State<T>>> {
    private final AbstractFileStoreWrite<T> write;
    private final KeyAndBucketExtractor<InternalRow> keyAndBucketExtractor;
    private final RecordExtractor<T> recordExtractor;
    private boolean batchCommitted = false;
    private String tableName;

    public TableWriteImpl(FileStoreWrite<T> write, KeyAndBucketExtractor<InternalRow> keyAndBucketExtractor, RecordExtractor<T> recordExtractor, String tableName) {
        this.write = (AbstractFileStoreWrite)write;
        this.keyAndBucketExtractor = keyAndBucketExtractor;
        this.recordExtractor = recordExtractor;
        this.tableName = tableName;
    }

    @Override
    public TableWriteImpl<T> withIgnorePreviousFiles(boolean ignorePreviousFiles) {
        this.write.withIgnorePreviousFiles(ignorePreviousFiles);
        return this;
    }

    @Override
    public TableWriteImpl<T> isStreamingMode(boolean isStreamingMode) {
        this.write.isStreamingMode(isStreamingMode);
        return this;
    }

    @Override
    public TableWriteImpl<T> withIOManager(IOManager ioManager) {
        this.write.withIOManager(ioManager);
        return this;
    }

    @Override
    public TableWriteImpl<T> withMemoryPool(MemorySegmentPool memoryPool) {
        this.write.withMemoryPool(memoryPool);
        return this;
    }

    public TableWriteImpl<T> withMemoryPoolFactory(MemoryPoolFactory memoryPoolFactory) {
        this.write.withMemoryPoolFactory(memoryPoolFactory);
        return this;
    }

    public TableWriteImpl<T> withCompactExecutor(ExecutorService compactExecutor) {
        this.write.withCompactExecutor(compactExecutor);
        return this;
    }

    @Override
    public BinaryRow getPartition(InternalRow row) {
        this.keyAndBucketExtractor.setRecord(row);
        return this.keyAndBucketExtractor.partition();
    }

    @Override
    public int getBucket(InternalRow row) {
        this.keyAndBucketExtractor.setRecord(row);
        return this.keyAndBucketExtractor.bucket();
    }

    @Override
    public void write(InternalRow row) throws Exception {
        this.writeAndReturn(row);
    }

    public SinkRecord writeAndReturn(InternalRow row) throws Exception {
        SinkRecord record = this.toSinkRecord(row);
        this.write.write(record.partition(), record.bucket(), this.recordExtractor.extract(record));
        return record;
    }

    @VisibleForTesting
    public T writeAndReturnData(InternalRow row) throws Exception {
        SinkRecord record = this.toSinkRecord(row);
        T data = this.recordExtractor.extract(record);
        this.write.write(record.partition(), record.bucket(), data);
        return data;
    }

    private SinkRecord toSinkRecord(InternalRow row) {
        this.keyAndBucketExtractor.setRecord(row);
        return new SinkRecord(this.keyAndBucketExtractor.partition(), this.keyAndBucketExtractor.bucket(), this.keyAndBucketExtractor.trimmedPrimaryKey(), row);
    }

    public SinkRecord toLogRecord(SinkRecord record) {
        this.keyAndBucketExtractor.setRecord(record.row());
        return new SinkRecord(record.partition(), record.bucket(), this.keyAndBucketExtractor.logPrimaryKey(), record.row());
    }

    @Override
    public void compact(BinaryRow partition, int bucket, boolean fullCompaction) throws Exception {
        this.write.compact(partition, bucket, fullCompaction);
    }

    @Override
    public TableWriteImpl<T> withMetricRegistry(MetricRegistry metricRegistry) {
        this.write.withMetricRegistry(metricRegistry);
        return this;
    }

    public void notifyNewFiles(long snapshotId, BinaryRow partition, int bucket, List<DataFileMeta> files) {
        this.write.notifyNewFiles(snapshotId, partition, bucket, files);
    }

    @Override
    public List<CommitMessage> prepareCommit(boolean waitCompaction, long commitIdentifier) throws Exception {
        return this.write.prepareCommit(waitCompaction, commitIdentifier);
    }

    @Override
    public List<CommitMessage> prepareCommit() throws Exception {
        Preconditions.checkState((!this.batchCommitted ? 1 : 0) != 0, (Object)"BatchTableWrite only support one-time committing.");
        this.batchCommitted = true;
        return this.prepareCommit(true, Long.MAX_VALUE);
    }

    @Override
    public void close() throws Exception {
        this.write.close();
    }

    @Override
    public List<AbstractFileStoreWrite.State<T>> checkpoint() {
        return this.write.checkpoint();
    }

    @Override
    public void restore(List<AbstractFileStoreWrite.State<T>> state) {
        this.write.restore(state);
    }

    @VisibleForTesting
    public AbstractFileStoreWrite<T> getWrite() {
        return this.write;
    }

    public static interface RecordExtractor<T> {
        public T extract(SinkRecord var1);
    }
}

