/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.util.ArrayList;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.stats.BinaryTableStats;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.SerializationUtils;

public class FieldStatsArraySerializer {
    private final InternalRowSerializer serializer;
    private final InternalRow.FieldGetter[] fieldGetters;
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final CastExecutor<Object, Object>[] converterMapping;

    public FieldStatsArraySerializer(RowType type) {
        this(type, null, null);
    }

    public FieldStatsArraySerializer(RowType type, int[] indexMapping, CastExecutor<Object, Object>[] converterMapping) {
        RowType safeType = FieldStatsArraySerializer.toAllFieldsNullableRowType(type);
        this.serializer = new InternalRowSerializer(safeType);
        this.fieldGetters = (InternalRow.FieldGetter[])IntStream.range(0, safeType.getFieldCount()).mapToObj(i -> InternalRowUtils.createNullCheckingFieldGetter((DataType)safeType.getTypeAt(i), (int)i)).toArray(InternalRow.FieldGetter[]::new);
        this.indexMapping = indexMapping;
        this.converterMapping = converterMapping;
    }

    public BinaryTableStats toBinary(FieldStats[] stats) {
        int rowFieldCount = stats.length;
        GenericRow minValues = new GenericRow(rowFieldCount);
        GenericRow maxValues = new GenericRow(rowFieldCount);
        Long[] nullCounts = new Long[rowFieldCount];
        for (int i = 0; i < rowFieldCount; ++i) {
            minValues.setField(i, stats[i].minValue());
            maxValues.setField(i, stats[i].maxValue());
            nullCounts[i] = stats[i].nullCount();
        }
        return new BinaryTableStats(this.serializer.toBinaryRow((InternalRow)minValues).copy(), this.serializer.toBinaryRow((InternalRow)maxValues).copy(), nullCounts, stats);
    }

    public FieldStats[] fromBinary(BinaryTableStats array) {
        return this.fromBinary(array, null);
    }

    public FieldStats[] fromBinary(BinaryTableStats array, @Nullable Long rowCount) {
        int fieldCount = this.indexMapping == null ? this.fieldGetters.length : this.indexMapping.length;
        FieldStats[] stats = new FieldStats[fieldCount];
        Long[] nullCounts = array.nullCounts();
        for (int i = 0; i < fieldCount; ++i) {
            int fieldIndex;
            int n = fieldIndex = this.indexMapping == null ? i : this.indexMapping[i];
            if (fieldIndex < 0 || fieldIndex >= array.min().getFieldCount()) {
                if (rowCount == null) {
                    throw new RuntimeException("Schema Evolution for stats needs row count.");
                }
                stats[i] = new FieldStats(null, null, rowCount);
                continue;
            }
            CastExecutor<Object, Object> converter = this.converterMapping == null ? null : this.converterMapping[i];
            Object min = this.fieldGetters[fieldIndex].getFieldOrNull((InternalRow)array.min());
            min = converter == null || min == null ? min : converter.cast(min);
            Object max = this.fieldGetters[fieldIndex].getFieldOrNull((InternalRow)array.max());
            max = converter == null || max == null ? max : converter.cast(max);
            stats[i] = new FieldStats(min, max, nullCounts[fieldIndex]);
        }
        return stats;
    }

    public static RowType schema() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "_MIN_VALUES", (DataType)SerializationUtils.newBytesType(false)));
        fields.add(new DataField(1, "_MAX_VALUES", (DataType)SerializationUtils.newBytesType(false)));
        fields.add(new DataField(2, "_NULL_COUNTS", (DataType)new ArrayType((DataType)new BigIntType(true))));
        return new RowType(fields);
    }

    private static RowType toAllFieldsNullableRowType(RowType rowType) {
        return RowType.builder().fields((DataType[])rowType.getFields().stream().map(f -> f.type().copy(true)).toArray(DataType[]::new), rowType.getFieldNames().toArray(new String[0])).build();
    }
}

