/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.sort.zorder;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.ZOrderByteUtils;

public class ZIndexer
implements Serializable {
    private final Set<RowProcessor> functionSet;
    private final int[] fieldsIndex;
    private final int totalBytes;
    private transient ByteBuffer reuse;

    public ZIndexer(RowType rowType, List<String> orderColumns) {
        this(rowType, orderColumns, 8);
    }

    public ZIndexer(RowType rowType, List<String> orderColumns, int varTypeSize) {
        List fields = rowType.getFieldNames();
        this.fieldsIndex = new int[orderColumns.size()];
        int varTypeCount = 0;
        for (int i = 0; i < this.fieldsIndex.length; ++i) {
            int index = fields.indexOf(orderColumns.get(i));
            if (index == -1) {
                throw new IllegalArgumentException("Can't find column: " + orderColumns.get(i) + " in row type fields: " + fields);
            }
            this.fieldsIndex[i] = index;
            if (!ZIndexer.isVarType((DataType)rowType.getFieldTypes().get(index))) continue;
            ++varTypeCount;
        }
        this.functionSet = this.constructFunctionMap(rowType.getFields(), varTypeSize);
        this.totalBytes = 8 * (this.fieldsIndex.length - varTypeCount) + varTypeSize * varTypeCount;
    }

    private static boolean isVarType(DataType dataType) {
        return dataType instanceof CharType || dataType instanceof VarCharType || dataType instanceof BinaryType || dataType instanceof VarBinaryType;
    }

    public void open() {
        this.reuse = ByteBuffer.allocate(this.totalBytes);
        this.functionSet.forEach(RowProcessor::open);
    }

    public int size() {
        return this.totalBytes;
    }

    public byte[] index(InternalRow row) {
        byte[][] columnBytes = new byte[this.fieldsIndex.length][];
        int index = 0;
        for (RowProcessor f : this.functionSet) {
            columnBytes[index++] = f.zvalue(row);
        }
        return ZOrderByteUtils.interleaveBits(columnBytes, this.totalBytes, this.reuse);
    }

    public Set<RowProcessor> constructFunctionMap(List<DataField> fields, int varTypeSize) {
        LinkedHashSet<RowProcessor> zorderFunctionSet = new LinkedHashSet<RowProcessor>();
        for (int index : this.fieldsIndex) {
            DataField field = fields.get(index);
            zorderFunctionSet.add(ZIndexer.zmapColumnToCalculator(field, index, varTypeSize));
        }
        return zorderFunctionSet;
    }

    public static RowProcessor zmapColumnToCalculator(DataField field, int index, int varTypeSize) {
        DataType type = field.type();
        return new RowProcessor((ZProcessFunction)type.accept((DataTypeVisitor)new TypeVisitor(index, varTypeSize)), ZIndexer.isVarType(type) ? varTypeSize : 8);
    }

    static interface ZProcessFunction
    extends BiFunction<InternalRow, ByteBuffer, byte[]>,
    Serializable {
    }

    public static class RowProcessor
    implements Serializable {
        private transient ByteBuffer reuse;
        private final ZProcessFunction process;
        private final int byteSize;

        public RowProcessor(ZProcessFunction process, int byteSize) {
            this.process = process;
            this.byteSize = byteSize;
        }

        public void open() {
            this.reuse = ByteBuffer.allocate(this.byteSize);
        }

        public byte[] zvalue(InternalRow o) {
            return (byte[])this.process.apply(o, this.reuse);
        }
    }

    public static class TypeVisitor
    implements DataTypeVisitor<ZProcessFunction>,
    Serializable {
        private final int fieldIndex;
        private final int varTypeSize;

        public TypeVisitor(int index, int varTypeSize) {
            this.fieldIndex = index;
            this.varTypeSize = varTypeSize;
        }

        public ZProcessFunction visit(CharType charType) {
            return (row, reuse) -> {
                BinaryString binaryString = row.getString(this.fieldIndex);
                return row.isNullAt(this.fieldIndex) ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.byteTruncateOrFill(MemorySegmentUtils.getBytes((MemorySegment[])binaryString.getSegments(), (int)binaryString.getOffset(), (int)Math.min(this.varTypeSize, binaryString.getSizeInBytes())), this.varTypeSize, reuse).array();
            };
        }

        public ZProcessFunction visit(VarCharType varCharType) {
            return (row, reuse) -> {
                BinaryString binaryString = row.getString(this.fieldIndex);
                return row.isNullAt(this.fieldIndex) ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.byteTruncateOrFill(MemorySegmentUtils.getBytes((MemorySegment[])binaryString.getSegments(), (int)binaryString.getOffset(), (int)Math.min(this.varTypeSize, binaryString.getSizeInBytes())), this.varTypeSize, reuse).array();
            };
        }

        public ZProcessFunction visit(BooleanType booleanType) {
            return (row, reuse) -> {
                if (row.isNullAt(this.fieldIndex)) {
                    return ZOrderByteUtils.NULL_BYTES;
                }
                ZOrderByteUtils.reuse(reuse, 8);
                reuse.put(0, (byte)(row.getBoolean(this.fieldIndex) ? -127 : 0));
                return reuse.array();
            };
        }

        public ZProcessFunction visit(BinaryType binaryType) {
            return (row, reuse) -> row.isNullAt(this.fieldIndex) ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.byteTruncateOrFill(row.getBinary(this.fieldIndex), this.varTypeSize, reuse).array();
        }

        public ZProcessFunction visit(VarBinaryType varBinaryType) {
            return (row, reuse) -> row.isNullAt(this.fieldIndex) ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.byteTruncateOrFill(row.getBinary(this.fieldIndex), this.varTypeSize, reuse).array();
        }

        public ZProcessFunction visit(DecimalType decimalType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter((DataType)decimalType, (int)this.fieldIndex);
            return (row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull(row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.byteTruncateOrFill(((Decimal)o).toUnscaledBytes(), 8, reuse).array();
            };
        }

        public ZProcessFunction visit(TinyIntType tinyIntType) {
            return (row, reuse) -> row.isNullAt(this.fieldIndex) ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.tinyintToOrderedBytes(row.getByte(this.fieldIndex), reuse).array();
        }

        public ZProcessFunction visit(SmallIntType smallIntType) {
            return (row, reuse) -> row.isNullAt(this.fieldIndex) ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.shortToOrderedBytes(row.getShort(this.fieldIndex), reuse).array();
        }

        public ZProcessFunction visit(IntType intType) {
            return (row, reuse) -> row.isNullAt(this.fieldIndex) ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.intToOrderedBytes(row.getInt(this.fieldIndex), reuse).array();
        }

        public ZProcessFunction visit(BigIntType bigIntType) {
            return (row, reuse) -> row.isNullAt(this.fieldIndex) ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.longToOrderedBytes(row.getLong(this.fieldIndex), reuse).array();
        }

        public ZProcessFunction visit(FloatType floatType) {
            return (row, reuse) -> row.isNullAt(this.fieldIndex) ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.floatToOrderedBytes(row.getFloat(this.fieldIndex), reuse).array();
        }

        public ZProcessFunction visit(DoubleType doubleType) {
            return (row, reuse) -> row.isNullAt(this.fieldIndex) ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.doubleToOrderedBytes(row.getDouble(this.fieldIndex), reuse).array();
        }

        public ZProcessFunction visit(DateType dateType) {
            return (row, reuse) -> row.isNullAt(this.fieldIndex) ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.intToOrderedBytes(row.getInt(this.fieldIndex), reuse).array();
        }

        public ZProcessFunction visit(TimeType timeType) {
            return (row, reuse) -> row.isNullAt(this.fieldIndex) ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.intToOrderedBytes(row.getInt(this.fieldIndex), reuse).array();
        }

        public ZProcessFunction visit(TimestampType timestampType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter((DataType)timestampType, (int)this.fieldIndex);
            return (row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull(row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.longToOrderedBytes(((Timestamp)o).getMillisecond(), reuse).array();
            };
        }

        public ZProcessFunction visit(LocalZonedTimestampType localZonedTimestampType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter((DataType)localZonedTimestampType, (int)this.fieldIndex);
            return (row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull(row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.longToOrderedBytes(((Timestamp)o).getMillisecond(), reuse).array();
            };
        }

        public ZProcessFunction visit(ArrayType arrayType) {
            throw new RuntimeException("Unsupported type");
        }

        public ZProcessFunction visit(MultisetType multisetType) {
            throw new RuntimeException("Unsupported type");
        }

        public ZProcessFunction visit(MapType mapType) {
            throw new RuntimeException("Unsupported type");
        }

        public ZProcessFunction visit(RowType rowType) {
            throw new RuntimeException("Unsupported type");
        }
    }
}

