/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateReplaceVisitor;
import org.apache.paimon.predicate.PredicateVisitor;
import org.apache.paimon.schema.IndexCastMapping;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.Preconditions;

public class SchemaEvolutionUtil {
    private static final int NULL_FIELD_INDEX = -1;

    @Nullable
    public static int[] createIndexMapping(List<DataField> tableFields, List<DataField> dataFields) {
        int i;
        int[] indexMapping = new int[tableFields.size()];
        HashMap<Integer, Integer> fieldIdToIndex = new HashMap<Integer, Integer>();
        for (i = 0; i < dataFields.size(); ++i) {
            fieldIdToIndex.put(dataFields.get(i).id(), i);
        }
        for (i = 0; i < tableFields.size(); ++i) {
            int fieldId = tableFields.get(i).id();
            Integer dataFieldIndex = (Integer)fieldIdToIndex.get(fieldId);
            indexMapping[i] = dataFieldIndex != null ? dataFieldIndex : -1;
        }
        for (i = 0; i < indexMapping.length; ++i) {
            if (indexMapping[i] == i) continue;
            return indexMapping;
        }
        return null;
    }

    public static IndexCastMapping createIndexCastMapping(int[] tableProjection, List<DataField> tableFields, int[] dataProjection, List<DataField> dataFields) {
        List<DataField> tableProjectFields = SchemaEvolutionUtil.projectDataFields(tableProjection, tableFields);
        List<DataField> dataProjectFields = SchemaEvolutionUtil.projectDataFields(dataProjection, dataFields);
        final int[] indexMapping = SchemaEvolutionUtil.createIndexMapping(tableProjectFields, dataProjectFields);
        final CastFieldGetter[] castMapping = SchemaEvolutionUtil.createCastFieldGetterMapping(tableProjectFields, dataProjectFields, indexMapping);
        return new IndexCastMapping(){

            @Override
            @Nullable
            public int[] getIndexMapping() {
                return indexMapping;
            }

            @Override
            @Nullable
            public CastFieldGetter[] getCastMapping() {
                return castMapping;
            }
        };
    }

    private static List<DataField> projectDataFields(int[] projection, List<DataField> dataFields) {
        ArrayList<DataField> projectFields = new ArrayList<DataField>(projection.length);
        for (int index : projection) {
            projectFields.add(dataFields.get(index));
        }
        return projectFields;
    }

    public static IndexCastMapping createIndexCastMapping(int[] tableProjection, List<DataField> tableKeyFields, List<DataField> tableValueFields, int[] dataProjection, List<DataField> dataKeyFields, List<DataField> dataValueFields) {
        int maxKeyId = Math.max(tableKeyFields.stream().mapToInt(DataField::id).max().orElse(0), dataKeyFields.stream().mapToInt(DataField::id).max().orElse(0));
        List<DataField> tableFields = KeyValue.createKeyValueFields(tableKeyFields, tableValueFields, maxKeyId);
        List<DataField> dataFields = KeyValue.createKeyValueFields(dataKeyFields, dataValueFields, maxKeyId);
        return SchemaEvolutionUtil.createIndexCastMapping(tableProjection, tableFields, dataProjection, dataFields);
    }

    public static int[][] createDataProjection(List<DataField> tableFields, List<DataField> dataFields, int[][] tableProjection) {
        List dataFieldIdList = dataFields.stream().map(DataField::id).collect(Collectors.toList());
        return (int[][])Arrays.stream(tableProjection).map(p -> Arrays.copyOf(p, ((int[])p).length)).peek(p -> {
            int fieldId = ((DataField)tableFields.get(p[0])).id();
            p[0] = dataFieldIdList.indexOf(fieldId);
        }).filter(p -> p[0] >= 0).toArray(x$0 -> new int[x$0][]);
    }

    @Nullable
    public static List<Predicate> createDataFilters(List<DataField> tableFields, List<DataField> dataFields, List<Predicate> filters) {
        if (filters == null) {
            return null;
        }
        Map<String, DataField> nameToTableFields = tableFields.stream().collect(Collectors.toMap(DataField::name, f -> f));
        LinkedHashMap idToDataFields = new LinkedHashMap();
        dataFields.forEach(f -> idToDataFields.put(f.id(), f));
        ArrayList<Predicate> dataFilters = new ArrayList<Predicate>(filters.size());
        PredicateReplaceVisitor visitor = predicate -> {
            DataType predicateType;
            DataField tableField = (DataField)Preconditions.checkNotNull(nameToTableFields.get(predicate.fieldName()), (String)String.format("Find no field %s", predicate.fieldName()));
            DataField dataField = (DataField)idToDataFields.get(tableField.id());
            if (dataField == null) {
                return Optional.empty();
            }
            DataType dataValueType = dataField.type().copy(true);
            CastExecutor<?, ?> castExecutor = dataValueType.equals((Object)(predicateType = predicate.type().copy(true))) ? null : CastExecutors.resolve(predicate.type(), dataField.type());
            List literals = predicate.literals().stream().map(v -> castExecutor == null ? v : castExecutor.cast(v)).collect(Collectors.toList());
            return Optional.of(new LeafPredicate(predicate.function(), dataField.type(), SchemaEvolutionUtil.indexOf(dataField, idToDataFields), dataField.name(), literals));
        };
        for (Predicate predicate2 : filters) {
            ((Optional)predicate2.visit((PredicateVisitor)visitor)).ifPresent(dataFilters::add);
        }
        return dataFilters;
    }

    private static int indexOf(DataField dataField, LinkedHashMap<Integer, DataField> dataFields) {
        int index = 0;
        for (Map.Entry<Integer, DataField> entry : dataFields.entrySet()) {
            if (dataField.id() == entry.getKey().intValue()) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException(String.format("Can't find data field %s", dataField.name()));
    }

    @Nullable
    public static CastExecutor<?, ?>[] createConvertMapping(List<DataField> tableFields, List<DataField> dataFields, int[] indexMapping) {
        CastExecutor[] converterMapping = new CastExecutor[tableFields.size()];
        boolean castExist = false;
        for (int i = 0; i < tableFields.size(); ++i) {
            int dataIndex;
            int n = dataIndex = indexMapping == null ? i : indexMapping[i];
            if (dataIndex < 0) {
                converterMapping[i] = CastExecutors.identityCastExecutor();
                continue;
            }
            DataField tableField = tableFields.get(i);
            DataField dataField = dataFields.get(dataIndex);
            if (dataField.type().equalsIgnoreNullable(tableField.type())) {
                converterMapping[i] = CastExecutors.identityCastExecutor();
                continue;
            }
            Preconditions.checkState((!tableField.type().is(DataTypeFamily.CONSTRUCTED) ? 1 : 0) != 0, (Object)"Only support column type evolution in atomic data type.");
            converterMapping[i] = (CastExecutor)Preconditions.checkNotNull(CastExecutors.resolve(dataField.type(), tableField.type()));
            castExist = true;
        }
        return castExist ? converterMapping : null;
    }

    private static CastFieldGetter[] createCastFieldGetterMapping(List<DataField> tableFields, List<DataField> dataFields, int[] indexMapping) {
        CastFieldGetter[] converterMapping = new CastFieldGetter[tableFields.size()];
        boolean castExist = false;
        for (int i = 0; i < tableFields.size(); ++i) {
            int dataIndex;
            int n = dataIndex = indexMapping == null ? i : indexMapping[i];
            if (dataIndex < 0) {
                converterMapping[i] = new CastFieldGetter((InternalRow.FieldGetter & Serializable)row -> null, CastExecutors.identityCastExecutor());
                continue;
            }
            DataField tableField = tableFields.get(i);
            DataField dataField = dataFields.get(dataIndex);
            if (dataField.type().equalsIgnoreNullable(tableField.type())) {
                converterMapping[i] = new CastFieldGetter(InternalRowUtils.createNullCheckingFieldGetter((DataType)dataField.type(), (int)i), CastExecutors.identityCastExecutor());
                continue;
            }
            Preconditions.checkState((!(tableField.type() instanceof MapType) && !(dataField.type() instanceof ArrayType) && !(dataField.type() instanceof MultisetType) && !(dataField.type() instanceof RowType) ? 1 : 0) != 0, (Object)"Only support column type evolution in atomic data type.");
            converterMapping[i] = new CastFieldGetter(InternalRowUtils.createNullCheckingFieldGetter((DataType)dataField.type(), (int)i), (CastExecutor)Preconditions.checkNotNull(CastExecutors.resolve(dataField.type(), tableField.type())));
            castExist = true;
        }
        return castExist ? converterMapping : null;
    }
}

