/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation.metrics;

import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.metrics.Histogram;
import org.apache.paimon.metrics.MetricGroup;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.operation.metrics.CompactionStats;

public class CompactionMetrics {
    private static final int HISTOGRAM_WINDOW_SIZE = 100;
    private static final String GROUP_NAME = "compaction";
    private final MetricGroup metricGroup;
    private Histogram durationHistogram;
    private CompactionStats latestCompaction;
    @VisibleForTesting
    static final String LAST_COMPACTION_DURATION = "lastCompactionDuration";
    @VisibleForTesting
    static final String COMPACTION_DURATION = "compactionDuration";
    @VisibleForTesting
    static final String LAST_TABLE_FILES_COMPACTED_BEFORE = "lastTableFilesCompactedBefore";
    @VisibleForTesting
    static final String LAST_TABLE_FILES_COMPACTED_AFTER = "lastTableFilesCompactedAfter";
    @VisibleForTesting
    static final String LAST_CHANGELOG_FILES_COMPACTED = "lastChangelogFilesCompacted";
    @VisibleForTesting
    static final String LAST_REWRITE_INPUT_FILE_SIZE = "lastRewriteInputFileSize";
    @VisibleForTesting
    static final String LAST_REWRITE_OUTPUT_FILE_SIZE = "lastRewriteOutputFileSize";
    @VisibleForTesting
    static final String LAST_REWRITE_CHANGELOG_FILE_SIZE = "lastRewriteChangelogFileSize";

    public CompactionMetrics(MetricRegistry registry, String tableName, String partition, int bucket) {
        this.metricGroup = registry.bucketMetricGroup(GROUP_NAME, tableName, partition, bucket);
        this.registerGenericCompactionMetrics();
    }

    @VisibleForTesting
    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    private void registerGenericCompactionMetrics() {
        this.metricGroup.gauge(LAST_COMPACTION_DURATION, () -> this.latestCompaction == null ? 0L : this.latestCompaction.getDuration());
        this.durationHistogram = this.metricGroup.histogram(COMPACTION_DURATION, 100);
        this.metricGroup.gauge(LAST_TABLE_FILES_COMPACTED_BEFORE, () -> this.latestCompaction == null ? 0L : this.latestCompaction.getCompactedDataFilesBefore());
        this.metricGroup.gauge(LAST_TABLE_FILES_COMPACTED_AFTER, () -> this.latestCompaction == null ? 0L : this.latestCompaction.getCompactedDataFilesAfter());
        this.metricGroup.gauge(LAST_CHANGELOG_FILES_COMPACTED, () -> this.latestCompaction == null ? 0L : this.latestCompaction.getCompactedChangelogs());
        this.metricGroup.gauge(LAST_REWRITE_INPUT_FILE_SIZE, () -> this.latestCompaction == null ? 0L : this.latestCompaction.getRewriteInputFileSize());
        this.metricGroup.gauge(LAST_REWRITE_OUTPUT_FILE_SIZE, () -> this.latestCompaction == null ? 0L : this.latestCompaction.getRewriteOutputFileSize());
        this.metricGroup.gauge(LAST_REWRITE_CHANGELOG_FILE_SIZE, () -> this.latestCompaction == null ? 0L : this.latestCompaction.getRewriteChangelogFileSize());
    }

    public void reportCompaction(CompactionStats compactionStats) {
        this.latestCompaction = compactionStats;
        this.durationHistogram.update(compactionStats.getDuration());
    }

    public void close() {
        this.metricGroup.close();
    }
}

