/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.mergetree.compact.FirstRowMergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Projection;

public class LookupMergeFunction
implements MergeFunction<KeyValue> {
    private final MergeFunction<KeyValue> mergeFunction;
    private final LinkedList<KeyValue> candidates = new LinkedList();
    private final InternalRowSerializer keySerializer;
    private final InternalRowSerializer valueSerializer;
    KeyValue highLevel;
    boolean containLevel0;

    public LookupMergeFunction(MergeFunction<KeyValue> mergeFunction, RowType keyType, RowType valueType) {
        this.mergeFunction = mergeFunction;
        this.keySerializer = new InternalRowSerializer(keyType);
        this.valueSerializer = new InternalRowSerializer(valueType);
    }

    @Override
    public void reset() {
        this.candidates.clear();
        this.highLevel = null;
        this.containLevel0 = false;
    }

    @Override
    public void add(KeyValue kv) {
        this.candidates.add(kv.copy(this.keySerializer, this.valueSerializer));
    }

    @Override
    public KeyValue getResult() {
        Iterator<KeyValue> descending = this.candidates.descendingIterator();
        while (descending.hasNext()) {
            KeyValue kv = descending.next();
            if (kv.level() > 0) {
                if (this.highLevel != null) {
                    descending.remove();
                    continue;
                }
                this.highLevel = kv;
                continue;
            }
            this.containLevel0 = true;
        }
        this.mergeFunction.reset();
        this.candidates.forEach(this.mergeFunction::add);
        return this.mergeFunction.getResult();
    }

    public static MergeFunctionFactory<KeyValue> wrap(MergeFunctionFactory<KeyValue> wrapped, RowType keyType, RowType valueType) {
        if (wrapped.create() instanceof FirstRowMergeFunction) {
            return wrapped;
        }
        return new Factory(wrapped, keyType, valueType);
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;
        private final MergeFunctionFactory<KeyValue> wrapped;
        private final RowType keyType;
        private final RowType rowType;

        private Factory(MergeFunctionFactory<KeyValue> wrapped, RowType keyType, RowType rowType) {
            this.wrapped = wrapped;
            this.keyType = keyType;
            this.rowType = rowType;
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            RowType valueType = projection == null ? this.rowType : Projection.of((int[][])projection).project(this.rowType);
            return new LookupMergeFunction(this.wrapped.create(projection), this.keyType, valueType);
        }

        @Override
        public MergeFunctionFactory.AdjustedProjection adjustProjection(@Nullable int[][] projection) {
            return this.wrapped.adjustProjection(projection);
        }
    }
}

