/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.options.Options;
import org.apache.paimon.types.RowType;

public class FirstRowMergeFunction
implements MergeFunction<KeyValue> {
    private final InternalRowSerializer keySerializer;
    private final InternalRowSerializer valueSerializer;
    private KeyValue first;
    private final boolean ignoreDelete;

    protected FirstRowMergeFunction(RowType keyType, RowType valueType, boolean ignoreDelete) {
        this.keySerializer = new InternalRowSerializer(keyType);
        this.valueSerializer = new InternalRowSerializer(valueType);
        this.ignoreDelete = ignoreDelete;
    }

    @Override
    public void reset() {
        this.first = null;
    }

    @Override
    public void add(KeyValue kv) {
        if (kv.valueKind().isRetract()) {
            if (this.ignoreDelete) {
                return;
            }
            throw new IllegalArgumentException("By default, First row merge engine can not accept DELETE/UPDATE_BEFORE records.\nYou can config 'first-row.ignore-delete' to ignore the DELETE/UPDATE_BEFORE records.");
        }
        if (this.first == null) {
            this.first = kv.copy(this.keySerializer, this.valueSerializer);
        }
    }

    @Override
    @Nullable
    public KeyValue getResult() {
        return this.first;
    }

    public static MergeFunctionFactory<KeyValue> factory(RowType keyType, RowType valueType, Options options) {
        return new Factory(keyType, valueType, options);
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;
        private final RowType keyType;
        private final RowType valueType;
        private final Options options;

        public Factory(RowType keyType, RowType valueType, Options options) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.options = options;
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            return new FirstRowMergeFunction(this.keyType, this.valueType, (Boolean)this.options.get(CoreOptions.FIRST_ROW_IGNORE_DELETE));
        }
    }
}

