/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.format.FormatKey;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.KeyValueDataFileRecordReader;
import org.apache.paimon.partition.PartitionUtils;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.AsyncRecordReader;
import org.apache.paimon.utils.BulkFormatMapping;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Projection;

public class KeyValueFileReaderFactory {
    private final FileIO fileIO;
    private final SchemaManager schemaManager;
    private final long schemaId;
    private final RowType keyType;
    private final RowType valueType;
    private final BulkFormatMapping.BulkFormatMappingBuilder bulkFormatMappingBuilder;
    private final DataFilePathFactory pathFactory;
    private final long asyncThreshold;
    private final Map<FormatKey, BulkFormatMapping> bulkFormatMappings;
    private final BinaryRow partition;

    private KeyValueFileReaderFactory(FileIO fileIO, SchemaManager schemaManager, long schemaId, RowType keyType, RowType valueType, BulkFormatMapping.BulkFormatMappingBuilder bulkFormatMappingBuilder, DataFilePathFactory pathFactory, long asyncThreshold, BinaryRow partition) {
        this.fileIO = fileIO;
        this.schemaManager = schemaManager;
        this.schemaId = schemaId;
        this.keyType = keyType;
        this.valueType = valueType;
        this.bulkFormatMappingBuilder = bulkFormatMappingBuilder;
        this.pathFactory = pathFactory;
        this.asyncThreshold = asyncThreshold;
        this.partition = partition;
        this.bulkFormatMappings = new HashMap<FormatKey, BulkFormatMapping>();
    }

    public RecordReader<KeyValue> createRecordReader(long schemaId, String fileName, long fileSize, int level) throws IOException {
        if (fileSize >= this.asyncThreshold && fileName.endsWith("orc")) {
            return new AsyncRecordReader<KeyValue>(() -> this.createRecordReader(schemaId, fileName, level, false, 2));
        }
        return this.createRecordReader(schemaId, fileName, level, true, null);
    }

    private RecordReader<KeyValue> createRecordReader(long schemaId, String fileName, int level, boolean reuseFormat, @Nullable Integer poolSize) throws IOException {
        String formatIdentifier = DataFilePathFactory.formatIdentifier(fileName);
        Supplier<BulkFormatMapping> formatSupplier = () -> this.bulkFormatMappingBuilder.build(formatIdentifier, this.schemaManager.schema(this.schemaId), this.schemaManager.schema(schemaId));
        BulkFormatMapping bulkFormatMapping = reuseFormat ? this.bulkFormatMappings.computeIfAbsent(new FormatKey(schemaId, formatIdentifier), key -> (BulkFormatMapping)formatSupplier.get()) : formatSupplier.get();
        return new KeyValueDataFileRecordReader(this.fileIO, bulkFormatMapping.getReaderFactory(), this.pathFactory.toPath(fileName), this.keyType, this.valueType, level, poolSize, bulkFormatMapping.getIndexMapping(), bulkFormatMapping.getCastMapping(), PartitionUtils.create(bulkFormatMapping.getPartitionPair(), this.partition));
    }

    public static Builder builder(FileIO fileIO, SchemaManager schemaManager, long schemaId, RowType keyType, RowType valueType, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory, KeyValueFieldsExtractor extractor, CoreOptions options) {
        return new Builder(fileIO, schemaManager, schemaId, keyType, valueType, formatDiscover, pathFactory, extractor, options);
    }

    public static class Builder {
        private final FileIO fileIO;
        private final SchemaManager schemaManager;
        private final long schemaId;
        private final RowType keyType;
        private final RowType valueType;
        private final FileFormatDiscover formatDiscover;
        private final FileStorePathFactory pathFactory;
        private final KeyValueFieldsExtractor extractor;
        private final int[][] fullKeyProjection;
        private final CoreOptions options;
        private int[][] keyProjection;
        private int[][] valueProjection;
        private RowType projectedKeyType;
        private RowType projectedValueType;

        private Builder(FileIO fileIO, SchemaManager schemaManager, long schemaId, RowType keyType, RowType valueType, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory, KeyValueFieldsExtractor extractor, CoreOptions options) {
            this.fileIO = fileIO;
            this.schemaManager = schemaManager;
            this.schemaId = schemaId;
            this.keyType = keyType;
            this.valueType = valueType;
            this.formatDiscover = formatDiscover;
            this.pathFactory = pathFactory;
            this.extractor = extractor;
            this.fullKeyProjection = Projection.range((int)0, (int)keyType.getFieldCount()).toNestedIndexes();
            this.options = options;
            this.keyProjection = this.fullKeyProjection;
            this.valueProjection = Projection.range((int)0, (int)valueType.getFieldCount()).toNestedIndexes();
            this.applyProjection();
        }

        public Builder copyWithoutProjection() {
            return new Builder(this.fileIO, this.schemaManager, this.schemaId, this.keyType, this.valueType, this.formatDiscover, this.pathFactory, this.extractor, this.options);
        }

        public Builder withKeyProjection(int[][] projection) {
            this.keyProjection = projection;
            this.applyProjection();
            return this;
        }

        public Builder withValueProjection(int[][] projection) {
            this.valueProjection = projection;
            this.applyProjection();
            return this;
        }

        public RowType projectedValueType() {
            return this.projectedValueType;
        }

        public KeyValueFileReaderFactory build(BinaryRow partition, int bucket) {
            return this.build(partition, bucket, true, Collections.emptyList());
        }

        public KeyValueFileReaderFactory build(BinaryRow partition, int bucket, boolean projectKeys, @Nullable List<Predicate> filters) {
            int[][] keyProjection = projectKeys ? this.keyProjection : this.fullKeyProjection;
            RowType projectedKeyType = projectKeys ? this.projectedKeyType : this.keyType;
            return new KeyValueFileReaderFactory(this.fileIO, this.schemaManager, this.schemaId, projectedKeyType, this.projectedValueType, BulkFormatMapping.newBuilder(this.formatDiscover, this.extractor, keyProjection, this.valueProjection, filters), this.pathFactory.createDataFilePathFactory(partition, bucket), this.options.fileReaderAsyncThreshold().getBytes(), partition);
        }

        private void applyProjection() {
            this.projectedKeyType = Projection.of((int[][])this.keyProjection).project(this.keyType);
            this.projectedValueType = Projection.of((int[][])this.valueProjection).project(this.valueType);
        }
    }
}

