/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.stats.BinaryTableStats;
import org.apache.paimon.stats.FieldStatsArraySerializer;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializationUtils;

public class DataFileMeta {
    public static final BinaryTableStats EMPTY_KEY_STATS = new BinaryTableStats(BinaryRow.EMPTY_ROW, BinaryRow.EMPTY_ROW, new Long[0]);
    public static final BinaryRow EMPTY_MIN_KEY = BinaryRow.EMPTY_ROW;
    public static final BinaryRow EMPTY_MAX_KEY = BinaryRow.EMPTY_ROW;
    public static final int DUMMY_LEVEL = 0;
    private final String fileName;
    private final long fileSize;
    private final long rowCount;
    private final BinaryRow minKey;
    private final BinaryRow maxKey;
    private final BinaryTableStats keyStats;
    private final BinaryTableStats valueStats;
    private final long minSequenceNumber;
    private final long maxSequenceNumber;
    private final long schemaId;
    private final int level;
    private final List<String> extraFiles;
    private final Timestamp creationTime;

    public static DataFileMeta forAppend(String fileName, long fileSize, long rowCount, BinaryTableStats rowStats, long minSequenceNumber, long maxSequenceNumber, long schemaId) {
        return new DataFileMeta(fileName, fileSize, rowCount, EMPTY_MIN_KEY, EMPTY_MAX_KEY, EMPTY_KEY_STATS, rowStats, minSequenceNumber, maxSequenceNumber, schemaId, 0);
    }

    public DataFileMeta(String fileName, long fileSize, long rowCount, BinaryRow minKey, BinaryRow maxKey, BinaryTableStats keyStats, BinaryTableStats valueStats, long minSequenceNumber, long maxSequenceNumber, long schemaId, int level) {
        this(fileName, fileSize, rowCount, minKey, maxKey, keyStats, valueStats, minSequenceNumber, maxSequenceNumber, schemaId, level, Collections.emptyList(), Timestamp.fromLocalDateTime((LocalDateTime)LocalDateTime.now()).toMillisTimestamp());
    }

    public DataFileMeta(String fileName, long fileSize, long rowCount, BinaryRow minKey, BinaryRow maxKey, BinaryTableStats keyStats, BinaryTableStats valueStats, long minSequenceNumber, long maxSequenceNumber, long schemaId, int level, List<String> extraFiles, Timestamp creationTime) {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.rowCount = rowCount;
        this.minKey = minKey;
        this.maxKey = maxKey;
        this.keyStats = keyStats;
        this.valueStats = valueStats;
        this.minSequenceNumber = minSequenceNumber;
        this.maxSequenceNumber = maxSequenceNumber;
        this.level = level;
        this.schemaId = schemaId;
        this.extraFiles = Collections.unmodifiableList(extraFiles);
        this.creationTime = creationTime;
    }

    public String fileName() {
        return this.fileName;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public long rowCount() {
        return this.rowCount;
    }

    public BinaryRow minKey() {
        return this.minKey;
    }

    public BinaryRow maxKey() {
        return this.maxKey;
    }

    public BinaryTableStats keyStats() {
        return this.keyStats;
    }

    public BinaryTableStats valueStats() {
        return this.valueStats;
    }

    public long minSequenceNumber() {
        return this.minSequenceNumber;
    }

    public long maxSequenceNumber() {
        return this.maxSequenceNumber;
    }

    public long schemaId() {
        return this.schemaId;
    }

    public int level() {
        return this.level;
    }

    public List<String> extraFiles() {
        return this.extraFiles;
    }

    public Timestamp creationTime() {
        return this.creationTime;
    }

    public long creationTimeEpochMillis() {
        return this.creationTime.toLocalDateTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public Optional<CoreOptions.FileFormatType> fileFormat() {
        String[] split = this.fileName.split("\\.");
        try {
            return Optional.of(CoreOptions.FileFormatType.valueOf((String)split[split.length - 1].toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public DataFileMeta upgrade(int newLevel) {
        Preconditions.checkArgument((newLevel > this.level ? 1 : 0) != 0);
        return new DataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, newLevel, this.extraFiles, this.creationTime);
    }

    public List<Path> collectFiles(DataFilePathFactory pathFactory) {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(pathFactory.toPath(this.fileName));
        this.extraFiles.forEach(f -> paths.add(pathFactory.toPath((String)f)));
        return paths;
    }

    public DataFileMeta copy(List<String> newExtraFiles) {
        return new DataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, newExtraFiles, this.creationTime);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataFileMeta)) {
            return false;
        }
        DataFileMeta that = (DataFileMeta)o;
        return Objects.equals(this.fileName, that.fileName) && this.fileSize == that.fileSize && this.rowCount == that.rowCount && Objects.equals(this.minKey, that.minKey) && Objects.equals(this.maxKey, that.maxKey) && Objects.equals(this.keyStats, that.keyStats) && Objects.equals(this.valueStats, that.valueStats) && this.minSequenceNumber == that.minSequenceNumber && this.maxSequenceNumber == that.maxSequenceNumber && this.schemaId == that.schemaId && this.level == that.level && Objects.equals(this.extraFiles, that.extraFiles) && Objects.equals(this.creationTime, that.creationTime);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime);
    }

    public String toString() {
        return String.format("{%s, %d, %d, %s, %s, %s, %s, %d, %d, %d, %d, %s, %s}", this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime);
    }

    public static RowType schema() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "_FILE_NAME", (DataType)SerializationUtils.newStringType(false)));
        fields.add(new DataField(1, "_FILE_SIZE", (DataType)new BigIntType(false)));
        fields.add(new DataField(2, "_ROW_COUNT", (DataType)new BigIntType(false)));
        fields.add(new DataField(3, "_MIN_KEY", (DataType)SerializationUtils.newBytesType(false)));
        fields.add(new DataField(4, "_MAX_KEY", (DataType)SerializationUtils.newBytesType(false)));
        fields.add(new DataField(5, "_KEY_STATS", (DataType)FieldStatsArraySerializer.schema()));
        fields.add(new DataField(6, "_VALUE_STATS", (DataType)FieldStatsArraySerializer.schema()));
        fields.add(new DataField(7, "_MIN_SEQUENCE_NUMBER", (DataType)new BigIntType(false)));
        fields.add(new DataField(8, "_MAX_SEQUENCE_NUMBER", (DataType)new BigIntType(false)));
        fields.add(new DataField(9, "_SCHEMA_ID", (DataType)new BigIntType(false)));
        fields.add(new DataField(10, "_LEVEL", (DataType)new IntType(false)));
        fields.add(new DataField(11, "_EXTRA_FILES", (DataType)new ArrayType(false, (DataType)SerializationUtils.newStringType(false))));
        fields.add(new DataField(12, "_CREATION_TIME", (DataType)DataTypes.TIMESTAMP_MILLIS()));
        return new RowType(fields);
    }

    public static long getMaxSequenceNumber(List<DataFileMeta> fileMetas) {
        return fileMetas.stream().map(DataFileMeta::maxSequenceNumber).max(Long::compare).orElse(-1L);
    }
}

