/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.EOFException;
import java.io.IOException;
import org.apache.paimon.data.AbstractPagedInputView;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.serializer.BinaryRowSerializer;
import org.apache.paimon.disk.BufferFileReader;
import org.apache.paimon.disk.FileIOChannel;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.memory.Buffer;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.MutableObjectIterator;

public class BufferFileReaderInputView
extends AbstractPagedInputView {
    private final BufferFileReader reader;
    private final MemorySegment segment;
    private int currentSegmentLimit;

    public BufferFileReaderInputView(FileIOChannel.ID id, IOManager ioManager, int segmentSize) throws IOException {
        this.reader = ioManager.createBufferFileReader(id);
        this.segment = MemorySegment.wrap((byte[])new byte[segmentSize]);
    }

    protected MemorySegment nextSegment(MemorySegment current) throws IOException {
        if (this.reader.hasReachedEndOfFile()) {
            throw new EOFException();
        }
        Buffer buffer = Buffer.create(this.segment);
        this.reader.readInto(buffer);
        this.currentSegmentLimit = buffer.getSize();
        return this.segment;
    }

    protected int getLimitForSegment(MemorySegment segment) {
        return this.currentSegmentLimit;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public FileIOChannel getChannel() {
        return this.reader;
    }

    public MutableObjectIterator<BinaryRow> createBinaryRowIterator(BinaryRowSerializer serializer) {
        return new BinaryRowChannelInputViewIterator(serializer);
    }

    private class BinaryRowChannelInputViewIterator
    implements MutableObjectIterator<BinaryRow> {
        protected final BinaryRowSerializer serializer;

        public BinaryRowChannelInputViewIterator(BinaryRowSerializer serializer) {
            this.serializer = serializer;
        }

        @Override
        public BinaryRow next(BinaryRow reuse) throws IOException {
            try {
                return this.serializer.deserializeFromPages(reuse, (AbstractPagedInputView)BufferFileReaderInputView.this);
            }
            catch (EOFException e) {
                BufferFileReaderInputView.this.close();
                return null;
            }
        }

        @Override
        public BinaryRow next() throws IOException {
            throw new UnsupportedOperationException("This method is disabled due to performance issue!");
        }
    }
}

