/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compact;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.operation.metrics.CompactionMetrics;
import org.apache.paimon.operation.metrics.CompactionStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactTask
implements Callable<CompactResult> {
    private static final Logger LOG = LoggerFactory.getLogger(CompactTask.class);
    @Nullable
    private final CompactionMetrics metrics;

    public CompactTask(@Nullable CompactionMetrics metrics) {
        this.metrics = metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompactResult call() throws Exception {
        CompactResult compactResult;
        block4: {
            long startMillis = System.currentTimeMillis();
            CompactResult result = null;
            try {
                result = this.doCompact();
                if (LOG.isDebugEnabled()) {
                    this.logMetric(startMillis, result.before(), result.after());
                }
                compactResult = result;
                if (this.metrics == null) break block4;
            }
            catch (Throwable throwable) {
                if (this.metrics != null) {
                    long duration = System.currentTimeMillis() - startMillis;
                    CompactionStats compactionStats = result == null ? new CompactionStats(duration, Collections.emptyList(), Collections.emptyList(), Collections.emptyList()) : new CompactionStats(duration, result.before(), result.after(), result.changelog());
                    this.metrics.reportCompaction(compactionStats);
                }
                throw throwable;
            }
            long duration = System.currentTimeMillis() - startMillis;
            CompactionStats compactionStats = result == null ? new CompactionStats(duration, Collections.emptyList(), Collections.emptyList(), Collections.emptyList()) : new CompactionStats(duration, result.before(), result.after(), result.changelog());
            this.metrics.reportCompaction(compactionStats);
        }
        return compactResult;
    }

    protected String logMetric(long startMillis, List<DataFileMeta> compactBefore, List<DataFileMeta> compactAfter) {
        return String.format("Done compacting %d files to %d files in %dms. Rewrite input file size = %d, output file size = %d", compactBefore.size(), compactAfter.size(), System.currentTimeMillis() - startMillis, this.collectRewriteSize(compactBefore), this.collectRewriteSize(compactAfter));
    }

    protected abstract CompactResult doCompact() throws Exception;

    private long collectRewriteSize(List<DataFileMeta> files) {
        return files.stream().mapToLong(DataFileMeta::fileSize).sum();
    }
}

