/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLock;
import org.apache.paimon.catalog.FileSystemCatalogOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;

public class FileSystemCatalog
extends AbstractCatalog {
    private final Path warehouse;

    public FileSystemCatalog(FileIO fileIO, Path warehouse) {
        super(fileIO);
        this.warehouse = warehouse;
    }

    public FileSystemCatalog(FileIO fileIO, Path warehouse, Options options) {
        super(fileIO, options);
        this.warehouse = warehouse;
    }

    @Override
    public Optional<CatalogLock.Factory> lockFactory() {
        return Optional.empty();
    }

    @Override
    public List<String> listDatabases() {
        ArrayList<String> databases = new ArrayList<String>();
        for (FileStatus status : FileSystemCatalog.uncheck(() -> this.fileIO.listStatus(this.warehouse))) {
            Path path = status.getPath();
            if (!status.isDir() || !FileSystemCatalog.isDatabase(path)) continue;
            databases.add(FileSystemCatalog.database(path));
        }
        return databases;
    }

    @Override
    protected boolean databaseExistsImpl(String databaseName) {
        return FileSystemCatalog.uncheck(() -> this.fileIO.exists(this.newDatabasePath(databaseName)));
    }

    @Override
    protected void createDatabaseImpl(String name) {
        FileSystemCatalog.uncheck(() -> this.fileIO.mkdirs(this.newDatabasePath(name)));
    }

    @Override
    protected void dropDatabaseImpl(String name) {
        FileSystemCatalog.uncheck(() -> this.fileIO.delete(this.newDatabasePath(name), true));
    }

    @Override
    protected List<String> listTablesImpl(String databaseName) {
        ArrayList<String> tables = new ArrayList<String>();
        for (FileStatus status : FileSystemCatalog.uncheck(() -> this.fileIO.listStatus(this.newDatabasePath(databaseName)))) {
            if (!status.isDir() || !this.tableExists(status.getPath())) continue;
            tables.add(status.getPath().getName());
        }
        return tables;
    }

    @Override
    public boolean tableExists(Identifier identifier) {
        if (this.isSystemTable(identifier)) {
            return super.tableExists(identifier);
        }
        return this.tableExists(this.getDataTableLocation(identifier));
    }

    private boolean tableExists(Path tablePath) {
        return new SchemaManager(this.fileIO, tablePath).listAllIds().size() > 0;
    }

    @Override
    public TableSchema getDataTableSchema(Identifier identifier) throws Catalog.TableNotExistException {
        Path path = this.getDataTableLocation(identifier);
        return new SchemaManager(this.fileIO, path).latest().orElseThrow(() -> new Catalog.TableNotExistException(identifier));
    }

    @Override
    protected void dropTableImpl(Identifier identifier) {
        Path path = this.getDataTableLocation(identifier);
        FileSystemCatalog.uncheck(() -> this.fileIO.delete(path, true));
    }

    @Override
    public void createTableImpl(Identifier identifier, Schema schema) {
        Path path = this.getDataTableLocation(identifier);
        FileSystemCatalog.uncheck(() -> new SchemaManager(this.fileIO, path).createTable(schema));
    }

    @Override
    public void renameTableImpl(Identifier fromTable, Identifier toTable) {
        Path fromPath = this.getDataTableLocation(fromTable);
        Path toPath = this.getDataTableLocation(toTable);
        FileSystemCatalog.uncheck(() -> this.fileIO.rename(fromPath, toPath));
    }

    @Override
    protected void alterTableImpl(Identifier identifier, List<SchemaChange> changes) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        new SchemaManager(this.fileIO, this.getDataTableLocation(identifier)).commitChanges(changes);
    }

    private static <T> T uncheck(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isDatabase(Path path) {
        return path.getName().endsWith(".db");
    }

    private static String database(Path path) {
        String name = path.getName();
        return name.substring(0, name.length() - ".db".length());
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public String warehouse() {
        return this.warehouse.toString();
    }

    @Override
    public boolean caseSensitive() {
        return (Boolean)this.catalogOptions.get(FileSystemCatalogOptions.CASE_SENSITIVE);
    }
}

