/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.append;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.compact.CompactFutureManager;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.compact.CompactTask;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.operation.metrics.CompactionMetrics;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendOnlyCompactManager
extends CompactFutureManager {
    private static final Logger LOG = LoggerFactory.getLogger(AppendOnlyCompactManager.class);
    private static final int FULL_COMPACT_MIN_FILE = 3;
    private final ExecutorService executor;
    private final TreeSet<DataFileMeta> toCompact;
    private final int minFileNum;
    private final int maxFileNum;
    private final long targetFileSize;
    private final CompactRewriter rewriter;
    private List<DataFileMeta> compacting;
    @Nullable
    private final CompactionMetrics metrics;

    public AppendOnlyCompactManager(ExecutorService executor, List<DataFileMeta> restored, int minFileNum, int maxFileNum, long targetFileSize, CompactRewriter rewriter, @Nullable CompactionMetrics metrics) {
        this.executor = executor;
        this.toCompact = new TreeSet<DataFileMeta>(AppendOnlyCompactManager.fileComparator(false));
        this.toCompact.addAll(restored);
        this.minFileNum = minFileNum;
        this.maxFileNum = maxFileNum;
        this.targetFileSize = targetFileSize;
        this.rewriter = rewriter;
        this.metrics = metrics;
    }

    @Override
    public void triggerCompaction(boolean fullCompaction) {
        if (fullCompaction) {
            this.triggerFullCompaction();
        } else {
            this.triggerCompactionWithBestEffort();
        }
    }

    private void triggerFullCompaction() {
        Preconditions.checkState((this.taskFuture == null ? 1 : 0) != 0, (Object)"A compaction task is still running while the user forces a new compaction. This is unexpected.");
        if (this.toCompact.size() < 3) {
            return;
        }
        this.taskFuture = this.executor.submit(new FullCompactTask(this.toCompact, this.targetFileSize, this.rewriter, this.metrics));
        this.compacting = new ArrayList<DataFileMeta>(this.toCompact);
        this.toCompact.clear();
    }

    private void triggerCompactionWithBestEffort() {
        if (this.taskFuture != null) {
            return;
        }
        Optional<List<DataFileMeta>> picked = this.pickCompactBefore();
        if (picked.isPresent()) {
            this.compacting = picked.get();
            this.taskFuture = this.executor.submit(new AutoCompactTask(this.compacting, this.rewriter, this.metrics));
        }
    }

    @Override
    public boolean shouldWaitForLatestCompaction() {
        return false;
    }

    @Override
    public boolean shouldWaitForPreparingCheckpoint() {
        return false;
    }

    @Override
    public void addNewFile(DataFileMeta file) {
        this.toCompact.add(file);
    }

    public List<DataFileMeta> allFiles() {
        ArrayList<DataFileMeta> allFiles = new ArrayList<DataFileMeta>();
        if (this.compacting != null) {
            allFiles.addAll(this.compacting);
        }
        allFiles.addAll(this.toCompact);
        return allFiles;
    }

    @Override
    public Optional<CompactResult> getCompactionResult(boolean blocking) throws ExecutionException, InterruptedException {
        Optional<CompactResult> result = this.innerGetCompactionResult(blocking);
        if (result.isPresent()) {
            DataFileMeta lastFile;
            CompactResult compactResult = result.get();
            if (!compactResult.after().isEmpty() && (lastFile = compactResult.after().get(compactResult.after().size() - 1)).fileSize() < this.targetFileSize) {
                this.toCompact.add(lastFile);
            }
            this.compacting = null;
        }
        return result;
    }

    @VisibleForTesting
    Optional<List<DataFileMeta>> pickCompactBefore() {
        if (this.toCompact.isEmpty()) {
            return Optional.empty();
        }
        long totalFileSize = 0L;
        int fileNum = 0;
        LinkedList<DataFileMeta> candidates = new LinkedList<DataFileMeta>();
        while (!this.toCompact.isEmpty()) {
            DataFileMeta file = this.toCompact.pollFirst();
            candidates.add(file);
            if ((totalFileSize += file.fileSize()) >= this.targetFileSize && ++fileNum >= this.minFileNum || fileNum >= this.maxFileNum) {
                return Optional.of(candidates);
            }
            if (totalFileSize < this.targetFileSize) continue;
            DataFileMeta removed = (DataFileMeta)candidates.pollFirst();
            assert (removed != null);
            totalFileSize -= removed.fileSize();
            --fileNum;
        }
        this.toCompact.addAll(candidates);
        return Optional.empty();
    }

    @VisibleForTesting
    TreeSet<DataFileMeta> getToCompact() {
        return this.toCompact;
    }

    @Override
    public void close() throws IOException {
        if (this.metrics != null) {
            this.metrics.close();
        }
    }

    private static CompactResult result(final List<DataFileMeta> before, final List<DataFileMeta> after) {
        return new CompactResult(){

            @Override
            public List<DataFileMeta> before() {
                return before;
            }

            @Override
            public List<DataFileMeta> after() {
                return after;
            }
        };
    }

    public static Comparator<DataFileMeta> fileComparator(boolean ignoreOverlap) {
        return (o1, o2) -> {
            if (o1 == o2) {
                return 0;
            }
            if (!ignoreOverlap && AppendOnlyCompactManager.isOverlap(o1, o2)) {
                LOG.warn(String.format("There should no overlap in append files, but Range1(%s, %s), Range2(%s, %s), check if you have multiple write jobs.", o1.minSequenceNumber(), o1.maxSequenceNumber(), o2.minSequenceNumber(), o2.maxSequenceNumber()));
            }
            return Long.compare(o1.minSequenceNumber(), o2.minSequenceNumber());
        };
    }

    private static boolean isOverlap(DataFileMeta o1, DataFileMeta o2) {
        return o2.minSequenceNumber() <= o1.maxSequenceNumber() && o2.maxSequenceNumber() >= o1.minSequenceNumber();
    }

    public static interface CompactRewriter {
        public List<DataFileMeta> rewrite(List<DataFileMeta> var1) throws Exception;
    }

    public static class AutoCompactTask
    extends CompactTask {
        private final List<DataFileMeta> toCompact;
        private final CompactRewriter rewriter;

        public AutoCompactTask(List<DataFileMeta> toCompact, CompactRewriter rewriter, @Nullable CompactionMetrics metrics) {
            super(metrics);
            this.toCompact = toCompact;
            this.rewriter = rewriter;
        }

        @Override
        protected CompactResult doCompact() throws Exception {
            return AppendOnlyCompactManager.result(this.toCompact, this.rewriter.rewrite(this.toCompact));
        }
    }

    public static class FullCompactTask
    extends CompactTask {
        private final LinkedList<DataFileMeta> inputs;
        private final long targetFileSize;
        private final CompactRewriter rewriter;

        public FullCompactTask(Collection<DataFileMeta> inputs, long targetFileSize, CompactRewriter rewriter, @Nullable CompactionMetrics metrics) {
            super(metrics);
            this.inputs = new LinkedList<DataFileMeta>(inputs);
            this.targetFileSize = targetFileSize;
            this.rewriter = rewriter;
        }

        @Override
        protected CompactResult doCompact() throws Exception {
            DataFileMeta file;
            while (!this.inputs.isEmpty() && (file = this.inputs.peekFirst()).fileSize() >= this.targetFileSize) {
                this.inputs.poll();
            }
            int big = 0;
            int small = 0;
            for (DataFileMeta file2 : this.inputs) {
                if (file2.fileSize() >= this.targetFileSize) {
                    ++big;
                    continue;
                }
                ++small;
            }
            ArrayList<Object> compactBefore = new ArrayList();
            List<Object> compactAfter = new ArrayList();
            if (small > big && this.inputs.size() >= 3) {
                compactBefore = new ArrayList<DataFileMeta>(this.inputs);
                compactAfter = this.rewriter.rewrite(this.inputs);
            }
            return AppendOnlyCompactManager.result(new ArrayList(compactBefore), compactAfter);
        }
    }
}

