/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.paimon.AbstractFileStore;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.index.HashIndexMaintainer;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.operation.KeyValueFileStoreRead;
import org.apache.paimon.operation.KeyValueFileStoreScan;
import org.apache.paimon.operation.KeyValueFileStoreWrite;
import org.apache.paimon.operation.ScanBucketFilter;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.KeyComparatorSupplier;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.ValueEqualiserSupplier;

public class KeyValueFileStore
extends AbstractFileStore<KeyValue> {
    private static final long serialVersionUID = 1L;
    private final boolean crossPartitionUpdate;
    private final RowType bucketKeyType;
    private final RowType keyType;
    private final RowType valueType;
    private final KeyValueFieldsExtractor keyValueFieldsExtractor;
    private final Supplier<Comparator<InternalRow>> keyComparatorSupplier;
    private final Supplier<RecordEqualiser> valueEqualiserSupplier;
    private final MergeFunctionFactory<KeyValue> mfFactory;
    private final String tableName;

    public KeyValueFileStore(FileIO fileIO, SchemaManager schemaManager, long schemaId, boolean crossPartitionUpdate, CoreOptions options, RowType partitionType, RowType bucketKeyType, RowType keyType, RowType valueType, KeyValueFieldsExtractor keyValueFieldsExtractor, MergeFunctionFactory<KeyValue> mfFactory, String tableName) {
        super(fileIO, schemaManager, schemaId, options, partitionType);
        this.crossPartitionUpdate = crossPartitionUpdate;
        this.bucketKeyType = bucketKeyType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyValueFieldsExtractor = keyValueFieldsExtractor;
        this.mfFactory = mfFactory;
        this.keyComparatorSupplier = new KeyComparatorSupplier(keyType);
        this.valueEqualiserSupplier = new ValueEqualiserSupplier(valueType);
        this.tableName = tableName;
    }

    @Override
    public BucketMode bucketMode() {
        if (this.options.bucket() == -1) {
            return this.crossPartitionUpdate ? BucketMode.GLOBAL_DYNAMIC : BucketMode.DYNAMIC;
        }
        Preconditions.checkArgument((!this.crossPartitionUpdate ? 1 : 0) != 0);
        return BucketMode.FIXED;
    }

    @Override
    public KeyValueFileStoreScan newScan() {
        return this.newScan(false);
    }

    public KeyValueFileStoreRead newRead() {
        return new KeyValueFileStoreRead(this.fileIO, this.schemaManager, this.schemaId, this.keyType, this.valueType, this.newKeyComparator(), this.mfFactory, FileFormatDiscover.of(this.options), this.pathFactory(), this.keyValueFieldsExtractor, this.options);
    }

    public KeyValueFileStoreWrite newWrite(String commitUser) {
        return this.newWrite(commitUser, null);
    }

    public KeyValueFileStoreWrite newWrite(String commitUser, ManifestCacheFilter manifestFilter) {
        HashIndexMaintainer.Factory indexFactory = null;
        if (this.bucketMode() == BucketMode.DYNAMIC) {
            indexFactory = new HashIndexMaintainer.Factory(this.newIndexFileHandler());
        }
        return new KeyValueFileStoreWrite(this.fileIO, this.schemaManager, this.schemaId, commitUser, this.keyType, this.valueType, this.keyComparatorSupplier, this.valueEqualiserSupplier, this.mfFactory, this.pathFactory(), this.format2PathFactory(), this.snapshotManager(), this.newScan(true).withManifestCacheFilter(manifestFilter), indexFactory, this.options, this.keyValueFieldsExtractor, this.tableName);
    }

    private Map<String, FileStorePathFactory> format2PathFactory() {
        HashMap<String, FileStorePathFactory> pathFactoryMap = new HashMap<String, FileStorePathFactory>();
        HashSet formats = new HashSet(this.options.fileFormatPerLevel().values());
        formats.add(this.options.fileFormat().getFormatIdentifier());
        formats.forEach(format -> pathFactoryMap.put((String)format, new FileStorePathFactory(this.options.path(), this.partitionType, this.options.partitionDefaultName(), (String)format)));
        return pathFactoryMap;
    }

    private KeyValueFileStoreScan newScan(boolean forWrite) {
        ScanBucketFilter bucketFilter = new ScanBucketFilter(this.bucketKeyType){

            @Override
            public void pushdown(Predicate keyFilter) {
                if (KeyValueFileStore.this.bucketMode() != BucketMode.FIXED) {
                    return;
                }
                List bucketFilters = PredicateBuilder.pickTransformFieldMapping((List)PredicateBuilder.splitAnd((Predicate)keyFilter), (List)KeyValueFileStore.this.keyType.getFieldNames(), (List)KeyValueFileStore.this.bucketKeyType.getFieldNames());
                if (bucketFilters.size() > 0) {
                    this.setBucketKeyFilter(PredicateBuilder.and((List)bucketFilters));
                }
            }
        };
        return new KeyValueFileStoreScan(this.partitionType, bucketFilter, this.snapshotManager(), this.schemaManager, this.schemaId, this.keyValueFieldsExtractor, this.manifestFileFactory(forWrite), this.manifestListFactory(forWrite), this.options.bucket(), forWrite, this.options.scanManifestParallelism());
    }

    @Override
    public Comparator<InternalRow> newKeyComparator() {
        return this.keyComparatorSupplier.get();
    }
}

