/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.paimon.schema.SchemaSerializer;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeJsonParser;
import org.apache.paimon.utils.JsonDeserializer;
import org.apache.paimon.utils.JsonSerializer;

public class JsonSerdeUtil {
    private static final ObjectMapper OBJECT_MAPPER_INSTANCE = new ObjectMapper();

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER_INSTANCE.reader().readValue(json, clazz);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> String toJson(T t) {
        try {
            return OBJECT_MAPPER_INSTANCE.writerWithDefaultPrettyPrinter().writeValueAsString(t);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static <T> String toFlatJson(T t) {
        try {
            return OBJECT_MAPPER_INSTANCE.writer().writeValueAsString(t);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private static Module createPaimonJacksonModule() {
        SimpleModule module = new SimpleModule("Paimon");
        JsonSerdeUtil.registerJsonObjects(module, TableSchema.class, SchemaSerializer.INSTANCE, SchemaSerializer.INSTANCE);
        JsonSerdeUtil.registerJsonObjects(module, DataField.class, DataField::serializeJson, DataTypeJsonParser::parseDataField);
        JsonSerdeUtil.registerJsonObjects(module, DataType.class, DataType::serializeJson, DataTypeJsonParser::parseDataType);
        return module;
    }

    private static <T> void registerJsonObjects(SimpleModule module, Class<T> clazz, final JsonSerializer<T> serializer, final JsonDeserializer<T> deserializer) {
        module.addSerializer((org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonSerializer)new StdSerializer<T>(clazz){

            public void serialize(T t, JsonGenerator generator, SerializerProvider provider) throws IOException {
                serializer.serialize(t, generator);
            }
        });
        module.addDeserializer(clazz, (org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonDeserializer)new StdDeserializer<T>(clazz){

            public T deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                return deserializer.deserialize((JsonNode)parser.readValueAsTree());
            }
        });
    }

    private JsonSerdeUtil() {
    }

    static {
        OBJECT_MAPPER_INSTANCE.registerModule(JsonSerdeUtil.createPaimonJacksonModule());
    }
}

