/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.paimon.utils.TagManager;

public class TagsTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String TAGS = "tags";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "tag_name", (DataType)SerializationUtils.newStringType(false)), new DataField(1, "snapshot_id", (DataType)new BigIntType(false)), new DataField(2, "schema_id", (DataType)new BigIntType(false)), new DataField(3, "commit_time", (DataType)new TimestampType(false, 3)), new DataField(4, "record_count", (DataType)new BigIntType(true))));
    private final FileIO fileIO;
    private final Path location;

    public TagsTable(FileIO fileIO, Path location) {
        this.fileIO = fileIO;
        this.location = location;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + TAGS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("tag_name");
    }

    @Override
    public InnerTableScan newScan() {
        return new TagsScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new TagsRead(this.fileIO);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new TagsTable(this.fileIO, this.location);
    }

    private static class TagsRead
    implements InnerTableRead {
        private final FileIO fileIO;
        private int[][] projection;

        public TagsRead(FileIO fileIO) {
            this.fileIO = fileIO;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            if (!(split instanceof TagsSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Path location = ((TagsSplit)split).location;
            SortedMap<Snapshot, String> tags = new TagManager(this.fileIO, location).tags();
            Iterator rows = Iterators.transform(tags.entrySet().iterator(), this::toRow);
            if (this.projection != null) {
                rows = Iterators.transform((Iterator)rows, row -> ProjectedRow.from((int[][])this.projection).replaceRow(row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private InternalRow toRow(Map.Entry<Snapshot, String> tag) {
            Snapshot snapshot = tag.getKey();
            return GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)tag.getValue()), snapshot.id(), snapshot.schemaId(), Timestamp.fromLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)snapshot.timeMillis())), snapshot.totalRecordCount()});
        }
    }

    private static class TagsSplit
    implements Split {
        private static final long serialVersionUID = 1L;
        private final FileIO fileIO;
        private final Path location;

        private TagsSplit(FileIO fileIO, Path location) {
            this.fileIO = fileIO;
            this.location = location;
        }

        @Override
        public long rowCount() {
            return new TagManager(this.fileIO, this.location).tagCount();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagsSplit that = (TagsSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class TagsScan
    extends ReadOnceTableScan {
        private TagsScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new TagsSplit(TagsTable.this.fileIO, TagsTable.this.location));
        }
    }
}

