/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.system.AllTableOptionsTable;
import org.apache.paimon.table.system.AuditLogTable;
import org.apache.paimon.table.system.ConsumersTable;
import org.apache.paimon.table.system.FilesTable;
import org.apache.paimon.table.system.ManifestsTable;
import org.apache.paimon.table.system.OptionsTable;
import org.apache.paimon.table.system.PartitionsTable;
import org.apache.paimon.table.system.SchemasTable;
import org.apache.paimon.table.system.SnapshotsTable;
import org.apache.paimon.table.system.TagsTable;

public class SystemTableLoader {
    @Nullable
    public static Table load(String type, FileIO fileIO, FileStoreTable dataTable) {
        Path location = dataTable.location();
        switch (type.toLowerCase()) {
            case "manifests": {
                return new ManifestsTable(fileIO, location, dataTable);
            }
            case "snapshots": {
                return new SnapshotsTable(fileIO, location, dataTable);
            }
            case "options": {
                return new OptionsTable(fileIO, location);
            }
            case "schemas": {
                return new SchemasTable(fileIO, location);
            }
            case "partitions": {
                return new PartitionsTable(dataTable);
            }
            case "audit_log": {
                return new AuditLogTable(dataTable);
            }
            case "files": {
                return new FilesTable(dataTable);
            }
            case "tags": {
                return new TagsTable(fileIO, location);
            }
            case "consumers": {
                return new ConsumersTable(fileIO, location);
            }
        }
        return null;
    }

    @Nullable
    public static Table loadGlobal(String tableName, FileIO fileIO, Map<String, Map<String, Path>> allTablePaths) {
        switch (tableName.toLowerCase()) {
            case "all_table_options": {
                return new AllTableOptionsTable(fileIO, allTablePaths);
            }
        }
        return null;
    }
}

