/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.InnerStreamTableScan;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class BucketsTable
implements DataTable,
ReadonlyTable {
    private static final long serialVersionUID = 1L;
    private final FileStoreTable wrapped;
    private final boolean isContinuous;

    public BucketsTable(FileStoreTable wrapped, boolean isContinuous) {
        this.wrapped = wrapped;
        this.isContinuous = isContinuous;
    }

    @Override
    public Path location() {
        return this.wrapped.location();
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.wrapped.snapshotManager();
    }

    @Override
    public TagManager tagManager() {
        return this.wrapped.tagManager();
    }

    @Override
    public String name() {
        return "__internal_buckets_" + this.wrapped.location().getName();
    }

    @Override
    public RowType rowType() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "_SNAPSHOT_ID", (DataType)new BigIntType(false)));
        fields.add(new DataField(1, "_PARTITION", (DataType)SerializationUtils.newBytesType(false)));
        fields.add(new DataField(2, "_BUCKET", (DataType)new IntType(false)));
        fields.add(new DataField(3, "_FILES", (DataType)SerializationUtils.newBytesType(false)));
        return new RowType(fields);
    }

    @Override
    public Map<String, String> options() {
        return this.wrapped.options();
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.emptyList();
    }

    @Override
    public SnapshotReader newSnapshotReader() {
        return this.wrapped.newSnapshotReader();
    }

    @Override
    public InnerTableScan newScan() {
        return this.wrapped.newScan();
    }

    @Override
    public InnerStreamTableScan newStreamScan() {
        return this.wrapped.newStreamScan();
    }

    @Override
    public CoreOptions coreOptions() {
        return this.wrapped.coreOptions();
    }

    @Override
    public InnerTableRead newRead() {
        return new BucketsRead();
    }

    @Override
    public BucketsTable copy(Map<String, String> dynamicOptions) {
        return new BucketsTable((FileStoreTable)this.wrapped.copy((Map)dynamicOptions), this.isContinuous);
    }

    @Override
    public FileIO fileIO() {
        return this.wrapped.fileIO();
    }

    private class BucketsRead
    implements InnerTableRead {
        private final DataFileMetaSerializer dataFileMetaSerializer = new DataFileMetaSerializer();

        private BucketsRead() {
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            throw new UnsupportedOperationException("BucketsRead does not support projection");
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            if (!(split instanceof DataSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            DataSplit dataSplit = (DataSplit)split;
            List<Object> files = Collections.emptyList();
            if (BucketsTable.this.isContinuous) {
                files = dataSplit.dataFiles();
            }
            GenericRow row = GenericRow.of((Object[])new Object[]{dataSplit.snapshotId(), SerializationUtils.serializeBinaryRow(dataSplit.partition()), dataSplit.bucket(), this.dataFileMetaSerializer.serializeList(files)});
            return new IteratorRecordReader<GenericRow>(Collections.singletonList(row).iterator());
        }
    }
}

