/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.operation.ScanKind;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFromTimestampStartingScanner
implements StartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(StaticFromTimestampStartingScanner.class);
    private final long startupMillis;

    public StaticFromTimestampStartingScanner(long startupMillis) {
        this.startupMillis = startupMillis;
    }

    @Override
    public StartingScanner.Result scan(SnapshotManager snapshotManager, SnapshotReader snapshotReader) {
        Snapshot startingSnapshot = StaticFromTimestampStartingScanner.timeTravelToTimestamp(snapshotManager, this.startupMillis);
        if (startingSnapshot == null) {
            LOG.debug("There is currently no snapshot earlier than or equal to timestamp[{}]", (Object)this.startupMillis);
            return new StartingScanner.NoSnapshot();
        }
        return StartingScanner.fromPlan(snapshotReader.withKind(ScanKind.ALL).withSnapshot(startingSnapshot.id()).read());
    }

    @Nullable
    public static Snapshot timeTravelToTimestamp(SnapshotManager snapshotManager, long timestamp) {
        return snapshotManager.earlierOrEqualTimeMills(timestamp);
    }
}

