/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.snapshot.IncrementalStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;

public class IncrementalTimeStampStartingScanner
implements StartingScanner {
    private final long startTimestamp;
    private final long endTimestamp;

    public IncrementalTimeStampStartingScanner(long startTimestamp, long endTimestamp) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
    }

    @Override
    public StartingScanner.Result scan(SnapshotManager manager, SnapshotReader reader) {
        Snapshot earliestSnapshot = manager.snapshot(manager.earliestSnapshotId());
        Snapshot latestSnapshot = manager.latestSnapshot();
        if (this.startTimestamp > latestSnapshot.timeMillis() || this.endTimestamp < earliestSnapshot.timeMillis()) {
            return new StartingScanner.NoSnapshot();
        }
        Snapshot startSnapshot = manager.earlierOrEqualTimeMills(this.startTimestamp);
        Long startSnapshotId = startSnapshot == null ? earliestSnapshot.id() - 1L : startSnapshot.id();
        Snapshot endSnapshot = manager.earlierOrEqualTimeMills(this.endTimestamp);
        Long endSnapshotId = endSnapshot == null ? latestSnapshot.id() : endSnapshot.id();
        IncrementalStartingScanner incrementalStartingScanner = new IncrementalStartingScanner(startSnapshotId, endSnapshotId);
        return incrementalStartingScanner.scan(manager, reader);
    }
}

