/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.Snapshot;
import org.apache.paimon.operation.ScanKind;
import org.apache.paimon.table.source.snapshot.FollowUpScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousAppendAndCompactFollowUpScanner
implements FollowUpScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousAppendAndCompactFollowUpScanner.class);

    @Override
    public boolean shouldScanSnapshot(Snapshot snapshot) {
        if (snapshot.commitKind() == Snapshot.CommitKind.APPEND || snapshot.commitKind() == Snapshot.CommitKind.COMPACT) {
            return true;
        }
        LOG.debug("Next snapshot id {} is not APPEND or COMPACT, but is {}, check next one.", (Object)snapshot.id(), (Object)snapshot.commitKind());
        return false;
    }

    @Override
    public SnapshotReader.Plan scan(long snapshotId, SnapshotReader snapshotReader) {
        return snapshotReader.withKind(ScanKind.DELTA).withSnapshot(snapshotId).read();
    }
}

