/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.io.IOException;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.source.ResetRowKindRecordIterator;
import org.apache.paimon.types.RowKind;

public class ValueCountRowDataRecordIterator
extends ResetRowKindRecordIterator {
    private InternalRow rowData = null;
    private long count = 0L;

    public ValueCountRowDataRecordIterator(RecordReader.RecordIterator<KeyValue> kvIterator) {
        super(kvIterator);
    }

    public InternalRow next() throws IOException {
        while (true) {
            if (this.count > 0L) {
                --this.count;
                return this.rowData;
            }
            KeyValue kv = this.nextKeyValue();
            if (kv == null) {
                return null;
            }
            this.rowData = kv.key();
            long value = kv.value().getLong(0);
            if (value < 0L) {
                this.rowData.setRowKind(RowKind.DELETE);
            }
            this.count = Math.abs(value);
        }
    }
}

