/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.util.Arrays;
import java.util.Objects;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.InnerTable;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.StreamTableScan;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Projection;
import org.apache.paimon.utils.TypeUtils;

public class ReadBuilderImpl
implements ReadBuilder {
    private static final long serialVersionUID = 1L;
    private final InnerTable table;
    private Predicate filter;
    private int[][] projection;

    public ReadBuilderImpl(InnerTable table) {
        this.table = table;
    }

    @Override
    public String tableName() {
        return this.table.name();
    }

    @Override
    public RowType readType() {
        if (this.projection == null) {
            return this.table.rowType();
        }
        return TypeUtils.project((RowType)this.table.rowType(), (int[])Projection.of((int[][])this.projection).toTopLevelIndexes());
    }

    @Override
    public ReadBuilder withFilter(Predicate filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public ReadBuilder withProjection(int[][] projection) {
        this.projection = projection;
        return this;
    }

    @Override
    public TableScan newScan() {
        return this.table.newScan().withFilter(this.filter);
    }

    @Override
    public StreamTableScan newStreamScan() {
        return (StreamTableScan)((Object)this.table.newStreamScan().withFilter(this.filter));
    }

    @Override
    public TableRead newRead() {
        InnerTableRead read = this.table.newRead().withFilter(this.filter);
        if (this.projection != null) {
            read.withProjection(this.projection);
        }
        return read;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadBuilderImpl that = (ReadBuilderImpl)o;
        return Objects.equals(this.table.name(), that.table.name()) && Objects.equals(this.filter, that.filter) && Arrays.deepEquals((Object[])this.projection, (Object[])that.projection);
    }

    public int hashCode() {
        int result = Objects.hash(this.table.name(), this.filter);
        result = 31 * result + Arrays.deepHashCode((Object[])this.projection);
        return result;
    }
}

