/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import org.apache.paimon.CoreOptions;
import org.apache.paimon.operation.DefaultValueAssigner;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.source.AbstractInnerTableScan;
import org.apache.paimon.table.source.DataFilePlan;
import org.apache.paimon.table.source.EndOfScanException;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;

public class InnerTableScanImpl
extends AbstractInnerTableScan {
    private final SnapshotManager snapshotManager;
    private final DefaultValueAssigner defaultValueAssigner;
    private StartingScanner startingScanner;
    private boolean hasNext;

    public InnerTableScanImpl(CoreOptions options, SnapshotReader snapshotReader, SnapshotManager snapshotManager, DefaultValueAssigner defaultValueAssigner) {
        super(options, snapshotReader);
        this.snapshotManager = snapshotManager;
        this.hasNext = true;
        this.defaultValueAssigner = defaultValueAssigner;
    }

    @Override
    public InnerTableScan withFilter(Predicate predicate) {
        this.snapshotReader.withFilter(this.defaultValueAssigner.handlePredicate(predicate));
        return this;
    }

    @Override
    public DataFilePlan plan() {
        if (this.startingScanner == null) {
            this.startingScanner = this.createStartingScanner(false);
        }
        if (this.hasNext) {
            this.hasNext = false;
            StartingScanner.Result result = this.startingScanner.scan(this.snapshotManager, this.snapshotReader);
            return DataFilePlan.fromResult(result);
        }
        throw new EndOfScanException();
    }
}

