/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataInputViewStreamWrapper;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializationUtils;

public class DataSplit
implements Split {
    private static final long serialVersionUID = 3L;
    private long snapshotId = 0L;
    private boolean isStreaming = false;
    private List<DataFileMeta> beforeFiles = new ArrayList<DataFileMeta>();
    private BinaryRow partition;
    private int bucket = -1;
    private List<DataFileMeta> dataFiles;

    public long snapshotId() {
        return this.snapshotId;
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public int bucket() {
        return this.bucket;
    }

    public List<DataFileMeta> beforeFiles() {
        return this.beforeFiles;
    }

    public List<DataFileMeta> dataFiles() {
        return this.dataFiles;
    }

    public boolean isStreaming() {
        return this.isStreaming;
    }

    public OptionalLong getLatestFileCreationEpochMillis() {
        return this.dataFiles.stream().mapToLong(DataFileMeta::creationTimeEpochMillis).max();
    }

    @Override
    public long rowCount() {
        long rowCount = 0L;
        for (DataFileMeta file : this.dataFiles) {
            rowCount += file.rowCount();
        }
        return rowCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSplit split = (DataSplit)o;
        return this.bucket == split.bucket && Objects.equals(this.partition, split.partition) && Objects.equals(this.beforeFiles, split.beforeFiles) && Objects.equals(this.dataFiles, split.dataFiles) && this.isStreaming == split.isStreaming;
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.bucket, this.beforeFiles, this.dataFiles, this.isStreaming);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.serialize((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.assign(DataSplit.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)in)));
    }

    private void assign(DataSplit other) {
        this.snapshotId = other.snapshotId;
        this.partition = other.partition;
        this.bucket = other.bucket;
        this.beforeFiles = other.beforeFiles;
        this.dataFiles = other.dataFiles;
        this.isStreaming = other.isStreaming;
    }

    public void serialize(DataOutputView out) throws IOException {
        out.writeLong(this.snapshotId);
        SerializationUtils.serializeBinaryRow(this.partition, out);
        out.writeInt(this.bucket);
        DataFileMetaSerializer dataFileSer = new DataFileMetaSerializer();
        out.writeInt(this.beforeFiles.size());
        for (DataFileMeta file : this.beforeFiles) {
            dataFileSer.serialize(file, out);
        }
        out.writeInt(this.dataFiles.size());
        for (DataFileMeta file : this.dataFiles) {
            dataFileSer.serialize(file, out);
        }
        out.writeBoolean(this.isStreaming);
    }

    public static DataSplit deserialize(DataInputView in) throws IOException {
        long snapshotId = in.readLong();
        BinaryRow partition = SerializationUtils.deserializeBinaryRow(in);
        int bucket = in.readInt();
        DataFileMetaSerializer dataFileSer = new DataFileMetaSerializer();
        int beforeNumber = in.readInt();
        ArrayList<DataFileMeta> beforeFiles = new ArrayList<DataFileMeta>(beforeNumber);
        for (int i = 0; i < beforeNumber; ++i) {
            beforeFiles.add((DataFileMeta)dataFileSer.deserialize(in));
        }
        int fileNumber = in.readInt();
        ArrayList<DataFileMeta> dataFiles = new ArrayList<DataFileMeta>(fileNumber);
        for (int i = 0; i < fileNumber; ++i) {
            dataFiles.add((DataFileMeta)dataFileSer.deserialize(in));
        }
        boolean isStreaming = in.readBoolean();
        return DataSplit.builder().withSnapshot(snapshotId).withPartition(partition).withBucket(bucket).withBeforeFiles(beforeFiles).withDataFiles(dataFiles).isStreaming(isStreaming).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final DataSplit split = new DataSplit();

        public Builder withSnapshot(long snapshot) {
            this.split.snapshotId = snapshot;
            return this;
        }

        public Builder withPartition(BinaryRow partition) {
            this.split.partition = partition;
            return this;
        }

        public Builder withBucket(int bucket) {
            this.split.bucket = bucket;
            return this;
        }

        public Builder withBeforeFiles(List<DataFileMeta> beforeFiles) {
            this.split.beforeFiles = beforeFiles;
            return this;
        }

        public Builder withDataFiles(List<DataFileMeta> dataFiles) {
            this.split.dataFiles = dataFiles;
            return this;
        }

        public Builder isStreaming(boolean isStreaming) {
            this.split.isStreaming = isStreaming;
            return this;
        }

        public DataSplit build() {
            Preconditions.checkArgument((this.split.partition != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.split.bucket != -1 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.split.dataFiles != null ? 1 : 0) != 0);
            DataSplit split = new DataSplit();
            split.assign(this.split);
            return split;
        }
    }
}

