/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import org.apache.paimon.CoreOptions;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;
import org.apache.paimon.table.sink.RowKeyExtractor;
import org.apache.paimon.utils.Preconditions;

public class FixedBucketRowKeyExtractor
extends RowKeyExtractor {
    private final int numBuckets;
    private final boolean sameBucketKeyAndTrimmedPrimaryKey;
    private final Projection bucketKeyProjection;
    private BinaryRow reuseBucketKey;
    private Integer reuseBucket;

    public FixedBucketRowKeyExtractor(TableSchema schema) {
        super(schema);
        this.numBuckets = new CoreOptions(schema.options()).bucket();
        Preconditions.checkArgument((this.numBuckets > 0 ? 1 : 0) != 0, (Object)("Num bucket is illegal: " + this.numBuckets));
        this.sameBucketKeyAndTrimmedPrimaryKey = schema.bucketKeys().equals(schema.trimmedPrimaryKeys());
        this.bucketKeyProjection = CodeGenUtils.newProjection(schema.logicalRowType(), schema.projection(schema.bucketKeys()));
    }

    @Override
    public void setRecord(InternalRow record) {
        super.setRecord(record);
        this.reuseBucketKey = null;
        this.reuseBucket = null;
    }

    private BinaryRow bucketKey() {
        if (this.sameBucketKeyAndTrimmedPrimaryKey) {
            return this.trimmedPrimaryKey();
        }
        if (this.reuseBucketKey == null) {
            this.reuseBucketKey = this.bucketKeyProjection.apply(this.record);
        }
        return this.reuseBucketKey;
    }

    @Override
    public int bucket() {
        BinaryRow bucketKey = this.bucketKey();
        if (this.reuseBucket == null) {
            this.reuseBucket = KeyAndBucketExtractor.bucket(KeyAndBucketExtractor.bucketKeyHashCode(bucketKey), this.numBuckets);
        }
        return this.reuseBucket;
    }
}

