/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.KeyValueFileStore;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.mergetree.compact.ValueCountMergeFunction;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.KeyValueFileStoreScan;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.BinaryTableStats;
import org.apache.paimon.table.AbstractFileStoreTable;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.KeyValueTableRead;
import org.apache.paimon.table.source.MergeTreeSplitGenerator;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.table.source.ValueCountRowDataRecordIterator;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;

public class ChangelogValueCountFileStoreTable
extends AbstractFileStoreTable {
    private static final long serialVersionUID = 1L;
    private transient KeyValueFileStore lazyStore;

    ChangelogValueCountFileStoreTable(FileIO fileIO, Path path, TableSchema tableSchema) {
        this(fileIO, path, tableSchema, new CatalogEnvironment(Lock.emptyFactory(), null, null));
    }

    ChangelogValueCountFileStoreTable(FileIO fileIO, Path path, TableSchema tableSchema, CatalogEnvironment catalogEnvironment) {
        super(fileIO, path, tableSchema, catalogEnvironment);
    }

    @Override
    protected FileStoreTable copy(TableSchema newTableSchema) {
        return new ChangelogValueCountFileStoreTable(this.fileIO, this.path, newTableSchema, this.catalogEnvironment);
    }

    public KeyValueFileStore store() {
        if (this.lazyStore == null) {
            ValueCountTableKeyValueFieldsExtractor extractor = ValueCountTableKeyValueFieldsExtractor.EXTRACTOR;
            RowType countType = new RowType(extractor.valueFields(this.tableSchema));
            this.lazyStore = new KeyValueFileStore(this.fileIO, this.schemaManager(), this.tableSchema.id(), false, new CoreOptions(this.tableSchema.options()), this.tableSchema.logicalPartitionType(), this.tableSchema.logicalBucketKeyType(), new RowType(extractor.keyFields(this.tableSchema)), countType, extractor, ValueCountMergeFunction.factory());
        }
        return this.lazyStore;
    }

    @Override
    public SplitGenerator splitGenerator() {
        return new MergeTreeSplitGenerator(this.store().newKeyComparator(), this.store().options().splitTargetSize(), this.store().options().splitOpenFileCost());
    }

    @Override
    public boolean supportStreamingReadOverwrite() {
        return false;
    }

    @Override
    public BiConsumer<FileStoreScan, Predicate> nonPartitionFilterConsumer() {
        return (scan, predicate) -> ((KeyValueFileStoreScan)scan).withKeyFilter((Predicate)predicate);
    }

    @Override
    public InnerTableRead innerRead() {
        return new KeyValueTableRead(this.store().newRead()){

            @Override
            public InnerTableRead withFilter(Predicate predicate) {
                this.read.withFilter(predicate);
                return this;
            }

            @Override
            public InnerTableRead withProjection(int[][] projection) {
                this.read.withKeyProjection(projection);
                return this;
            }

            @Override
            protected RecordReader.RecordIterator<InternalRow> rowDataRecordIteratorFromKv(RecordReader.RecordIterator<KeyValue> kvRecordIterator) {
                return new ValueCountRowDataRecordIterator(kvRecordIterator);
            }

            @Override
            public InnerTableRead forceKeepDelete() {
                this.read.forceKeepDelete();
                return this;
            }
        };
    }

    @Override
    public TableWriteImpl<KeyValue> newWrite(String commitUser) {
        return this.newWrite(commitUser, null);
    }

    public TableWriteImpl<KeyValue> newWrite(String commitUser, ManifestCacheFilter manifestFilter) {
        KeyValue kv = new KeyValue();
        return new TableWriteImpl<KeyValue>(this.store().newWrite(commitUser, manifestFilter), this.createRowKeyExtractor(), record -> {
            switch (record.row().getRowKind()) {
                case INSERT: 
                case UPDATE_AFTER: {
                    kv.replace(record.row(), RowKind.INSERT, (InternalRow)GenericRow.of((Object[])new Object[]{1L}));
                    break;
                }
                case UPDATE_BEFORE: 
                case DELETE: {
                    kv.replace(record.row(), RowKind.INSERT, (InternalRow)GenericRow.of((Object[])new Object[]{-1L}));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown row kind " + record.row().getRowKind());
                }
            }
            return kv;
        });
    }

    @Override
    public BinaryTableStats getSchemaFieldStats(DataFileMeta dataFileMeta) {
        return dataFileMeta.keyStats();
    }

    static class ValueCountTableKeyValueFieldsExtractor
    implements KeyValueFieldsExtractor {
        private static final long serialVersionUID = 1L;
        static final ValueCountTableKeyValueFieldsExtractor EXTRACTOR = new ValueCountTableKeyValueFieldsExtractor();

        private ValueCountTableKeyValueFieldsExtractor() {
        }

        @Override
        public List<DataField> keyFields(TableSchema schema) {
            return schema.fields();
        }

        @Override
        public List<DataField> valueFields(TableSchema schema) {
            return Collections.singletonList(new DataField(0, "_VALUE_COUNT", (DataType)new BigIntType(false)));
        }
    }
}

