/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaMergingUtils;
import org.apache.paimon.schema.SchemaValidation;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeCasts;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.JsonSerdeUtil;
import org.apache.paimon.utils.Preconditions;

public class SchemaManager
implements Serializable {
    private static final String SCHEMA_PREFIX = "schema-";
    private final FileIO fileIO;
    private final Path tableRoot;
    @Nullable
    private transient Lock lock;

    public SchemaManager(FileIO fileIO, Path tableRoot) {
        this.fileIO = fileIO;
        this.tableRoot = tableRoot;
    }

    public SchemaManager withLock(@Nullable Lock lock) {
        this.lock = lock;
        return this;
    }

    public Optional<TableSchema> latest() {
        try {
            return FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).reduce(Math::max).map(this::schema);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<TableSchema> listAll() {
        return this.listAllIds().stream().map(this::schema).collect(Collectors.toList());
    }

    public List<Long> listAllIds() {
        try {
            return FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TableSchema createTable(Schema schema) throws Exception {
        Map<String, String> options;
        List<String> primaryKeys;
        List<String> partitionKeys;
        int highestFieldId;
        List<DataField> fields;
        TableSchema newSchema;
        boolean success;
        do {
            this.latest().ifPresent(latest -> {
                throw new IllegalStateException("Schema in filesystem exists, please use updating, latest schema is: " + this.latest());
            });
            fields = schema.fields();
            partitionKeys = schema.partitionKeys();
            primaryKeys = schema.primaryKeys();
            options = schema.options();
        } while (!(success = this.commit(newSchema = new TableSchema(0L, fields, highestFieldId = RowType.currentHighestFieldId(fields), partitionKeys, primaryKeys, options, schema.comment()))));
        return newSchema;
    }

    public TableSchema commitChanges(SchemaChange ... changes) throws Exception {
        return this.commitChanges(Arrays.asList(changes));
    }

    /*
     * Exception decompiling
     */
    public TableSchema commitChanges(List<SchemaChange> changes) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean mergeSchema(RowType rowType, boolean allowExplicitCast) {
        TableSchema update;
        TableSchema current = this.latest().orElseThrow(() -> new RuntimeException("It requires that the current schema to exist when calling 'mergeSchema'"));
        if (current.equals(update = SchemaMergingUtils.mergeSchemas(current, rowType, allowExplicitCast))) {
            return false;
        }
        try {
            return this.commit(update);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to commit the schema.", e);
        }
    }

    private static void checkMoveIndexEqual(SchemaChange.Move move, int fieldIndex, int refIndex) {
        if (refIndex == fieldIndex) {
            throw new UnsupportedOperationException(String.format("Cannot move itself for column %s", move.fieldName()));
        }
    }

    private void validateNotPrimaryAndPartitionKey(TableSchema schema, String fieldName) {
        if (schema.partitionKeys().contains(fieldName)) {
            throw new UnsupportedOperationException(String.format("Cannot drop/rename partition key[%s]", fieldName));
        }
        if (schema.primaryKeys().contains(fieldName)) {
            throw new UnsupportedOperationException(String.format("Cannot drop/rename primary key[%s]", fieldName));
        }
    }

    private void updateNestedColumn(List<DataField> newFields, String[] updateFieldNames, int index, Function<DataField, DataField> updateFunc) throws Catalog.ColumnNotExistException {
        boolean found = false;
        for (int i = 0; i < newFields.size(); ++i) {
            DataField field = newFields.get(i);
            if (!field.name().equals(updateFieldNames[index])) continue;
            found = true;
            if (index == updateFieldNames.length - 1) {
                newFields.set(i, updateFunc.apply(field));
                break;
            }
            ArrayList<DataField> nestedFields = new ArrayList<DataField>(((RowType)field.type()).getFields());
            this.updateNestedColumn(nestedFields, updateFieldNames, index + 1, updateFunc);
            newFields.set(i, new DataField(field.id(), field.name(), (DataType)new RowType(field.type().isNullable(), nestedFields), field.description()));
        }
        if (!found) {
            throw new Catalog.ColumnNotExistException(SchemaManager.fromPath(this.tableRoot.getPath(), true), Arrays.toString(updateFieldNames));
        }
    }

    private void updateColumn(List<DataField> newFields, String updateFieldName, Function<DataField, DataField> updateFunc) throws Catalog.ColumnNotExistException {
        this.updateNestedColumn(newFields, new String[]{updateFieldName}, 0, updateFunc);
    }

    @VisibleForTesting
    boolean commit(TableSchema newSchema) throws Exception {
        SchemaValidation.validateTableSchema(newSchema);
        Path schemaPath = this.toSchemaPath(newSchema.id());
        Callable<Boolean> callable = () -> this.fileIO.writeFileUtf8(schemaPath, newSchema.toString());
        if (this.lock == null) {
            return callable.call();
        }
        return this.lock.runWithLock(callable);
    }

    public TableSchema schema(long id) {
        try {
            return JsonSerdeUtil.fromJson(this.fileIO.readFileUtf8(this.toSchemaPath(id)), TableSchema.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path schemaDirectory() {
        return new Path(this.tableRoot + "/schema");
    }

    @VisibleForTesting
    public Path toSchemaPath(long id) {
        return new Path(this.tableRoot + "/schema/" + SCHEMA_PREFIX + id);
    }

    public void deleteSchema(long schemaId) {
        this.fileIO.deleteQuietly(this.toSchemaPath(schemaId));
    }

    public static void checkAlterTableOption(String key) {
        if (CoreOptions.getImmutableOptionKeys().contains(key)) {
            throw new UnsupportedOperationException(String.format("Change '%s' is not supported yet.", key));
        }
    }

    public static void checkAlterTablePath(String key) {
        if (CoreOptions.PATH.key().equalsIgnoreCase(key)) {
            throw new UnsupportedOperationException("Change path is not supported yet.");
        }
    }

    public static Identifier fromPath(String tablePath, boolean ignoreIfUnknownDatabase) {
        String[] paths = tablePath.split("/");
        if (paths.length < 2) {
            if (!ignoreIfUnknownDatabase) {
                throw new IllegalArgumentException(String.format("Path '%s' is not a legacy path, please use catalog table path instead: 'warehouse_path/your_database.db/your_table'.", tablePath));
            }
            return new Identifier("unknown", paths[0]);
        }
        String database = paths[paths.length - 2];
        int index = database.lastIndexOf(".db");
        if (index == -1) {
            if (!ignoreIfUnknownDatabase) {
                throw new IllegalArgumentException(String.format("Path '%s' is not a legacy path, please use catalog table path instead: 'warehouse_path/your_database.db/your_table'.", tablePath));
            }
            return new Identifier("unknown", paths[paths.length - 1]);
        }
        database = database.substring(0, index);
        return new Identifier(database, paths[paths.length - 1]);
    }

    private static /* synthetic */ DataField lambda$commitChanges$8(SchemaChange.UpdateColumnComment update, DataField field) {
        return new DataField(field.id(), field.name(), field.type(), update.newDescription());
    }

    private static /* synthetic */ DataField lambda$commitChanges$7(SchemaChange.UpdateColumnNullability update, DataField field) {
        return new DataField(field.id(), field.name(), field.type().copy(update.newNullability()), field.description());
    }

    private static /* synthetic */ DataField lambda$commitChanges$6(SchemaChange.UpdateColumnType update, DataField field) {
        Preconditions.checkState((DataTypeCasts.supportsExplicitCast((DataType)field.type(), (DataType)update.newDataType()) && CastExecutors.resolve(field.type(), update.newDataType()) != null ? 1 : 0) != 0, (Object)String.format("Column type %s[%s] cannot be converted to %s without loosing information.", field.name(), field.type(), update.newDataType()));
        AtomicInteger dummyId = new AtomicInteger(0);
        if (dummyId.get() != 0) {
            throw new RuntimeException(String.format("Update column to nested row type '%s' is not supported.", update.newDataType()));
        }
        return new DataField(field.id(), field.name(), update.newDataType(), field.description());
    }

    private static /* synthetic */ boolean lambda$commitChanges$5(SchemaChange change, DataField f) {
        return f.name().equals(((SchemaChange.DropColumn)change).fieldName());
    }

    private static /* synthetic */ DataField lambda$commitChanges$4(SchemaChange.RenameColumn rename, DataField field) {
        return new DataField(field.id(), rename.newName(), field.type(), field.description());
    }

    private static /* synthetic */ boolean lambda$commitChanges$3(SchemaChange.RenameColumn rename, DataField f) {
        return f.name().equals(rename.newName());
    }

    private static /* synthetic */ boolean lambda$commitChanges$2(SchemaChange.AddColumn addColumn, DataField f) {
        return f.name().equals(addColumn.fieldName());
    }

    private /* synthetic */ Catalog.TableNotExistException lambda$commitChanges$1() {
        return new Catalog.TableNotExistException(SchemaManager.fromPath(this.tableRoot.getPath(), true));
    }
}

