/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.FileDeletionBase;
import org.apache.paimon.utils.FileStorePathFactory;

public class TagDeletion
extends FileDeletionBase {
    public TagDeletion(FileIO fileIO, FileStorePathFactory pathFactory, ManifestFile manifestFile, ManifestList manifestList, IndexFileHandler indexFileHandler) {
        super(fileIO, pathFactory, manifestFile, manifestList, indexFileHandler);
    }

    @Override
    public void cleanUnusedDataFiles(Snapshot taggedSnapshot, Predicate<ManifestEntry> skipper) {
        this.cleanUnusedDataFiles(this.tryReadDataManifestEntries(taggedSnapshot), skipper);
    }

    @Override
    public void cleanUnusedManifests(Snapshot taggedSnapshot, Set<String> skippingSet) {
        this.cleanUnusedManifests(taggedSnapshot, skippingSet, false);
    }

    public void cleanUnusedDataFiles(Iterable<ManifestEntry> entries, Predicate<ManifestEntry> skipper) {
        for (ManifestEntry entry : ManifestEntry.mergeEntries(entries)) {
            if (skipper.test(entry)) continue;
            Path bucketPath = this.pathFactory.bucketPath(entry.partition(), entry.bucket());
            this.fileIO.deleteQuietly(new Path(bucketPath, entry.file().fileName()));
            for (String file : entry.file().extraFiles()) {
                this.fileIO.deleteQuietly(new Path(bucketPath, file));
            }
            this.recordDeletionBuckets(entry);
        }
    }

    public Predicate<ManifestEntry> dataFileSkipper(Snapshot fromSnapshot) {
        return this.dataFileSkipper(Collections.singletonList(fromSnapshot));
    }

    public Predicate<ManifestEntry> dataFileSkipper(List<Snapshot> fromSnapshots) {
        HashMap<BinaryRow, Map<Integer, Set<String>>> skipped = new HashMap<BinaryRow, Map<Integer, Set<String>>>();
        for (Snapshot snapshot : fromSnapshots) {
            this.addMergedDataFiles(skipped, snapshot);
        }
        return entry -> this.containsDataFile((Map<BinaryRow, Map<Integer, Set<String>>>)skipped, (ManifestEntry)entry);
    }
}

