/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.AbstractFileStoreScan;
import org.apache.paimon.operation.ScanBucketFilter;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.stats.FieldStatsConverters;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;

public class KeyValueFileStoreScan
extends AbstractFileStoreScan {
    private final FieldStatsConverters fieldStatsConverters;
    private Predicate keyFilter;

    public KeyValueFileStoreScan(RowType partitionType, ScanBucketFilter bucketFilter, SnapshotManager snapshotManager, SchemaManager schemaManager, long schemaId, KeyValueFieldsExtractor keyValueFieldsExtractor, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, int numOfBuckets, boolean checkNumOfBuckets, Integer scanManifestParallelism) {
        super(partitionType, bucketFilter, snapshotManager, schemaManager, manifestFileFactory, manifestListFactory, numOfBuckets, checkNumOfBuckets, scanManifestParallelism);
        this.fieldStatsConverters = new FieldStatsConverters(sid -> keyValueFieldsExtractor.keyFields(this.scanTableSchema((long)sid)), schemaId);
    }

    public KeyValueFileStoreScan withKeyFilter(Predicate predicate) {
        this.keyFilter = predicate;
        this.bucketKeyFilter.pushdown(predicate);
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        return this.keyFilter == null || this.keyFilter.test(entry.file().rowCount(), entry.file().keyStats().fields(this.fieldStatsConverters.getOrCreate(entry.file().schemaId()), entry.file().rowCount()));
    }
}

