/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.List;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.operation.FileStoreExpire;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.operation.SnapshotDeletion;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreExpireImpl
implements FileStoreExpire {
    private static final Logger LOG = LoggerFactory.getLogger(FileStoreExpireImpl.class);
    private final int numRetainedMin;
    private final int numRetainedMax;
    private final long millisRetained;
    private final SnapshotManager snapshotManager;
    private final ConsumerManager consumerManager;
    private final SnapshotDeletion snapshotDeletion;
    private final TagManager tagManager;
    private Lock lock;

    public FileStoreExpireImpl(int numRetainedMin, int numRetainedMax, long millisRetained, SnapshotManager snapshotManager, SnapshotDeletion snapshotDeletion, TagManager tagManager) {
        Preconditions.checkArgument((numRetainedMin >= 1 ? 1 : 0) != 0, (Object)"The minimum number of completed snapshots to retain should be >= 1.");
        Preconditions.checkArgument((numRetainedMax >= numRetainedMin ? 1 : 0) != 0, (Object)"The maximum number of snapshots to retain should be >= the minimum number.");
        this.numRetainedMin = numRetainedMin;
        this.numRetainedMax = numRetainedMax;
        this.millisRetained = millisRetained;
        this.snapshotManager = snapshotManager;
        this.consumerManager = new ConsumerManager(snapshotManager.fileIO(), snapshotManager.tablePath());
        this.snapshotDeletion = snapshotDeletion;
        this.tagManager = tagManager;
    }

    @Override
    public FileStoreExpire withLock(Lock lock) {
        this.lock = lock;
        return this;
    }

    @Override
    public void expire() {
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (latestSnapshotId == null) {
            return;
        }
        long currentMillis = System.currentTimeMillis();
        Long earliest = this.snapshotManager.earliestSnapshotId();
        if (earliest == null) {
            return;
        }
        for (long id = Math.max(latestSnapshotId - (long)this.numRetainedMax + 1L, earliest); id <= latestSnapshotId - (long)this.numRetainedMin; ++id) {
            if (!this.snapshotManager.snapshotExists(id) || currentMillis - this.snapshotManager.snapshot(id).timeMillis() > this.millisRetained) continue;
            this.expireUntil(earliest, id);
            return;
        }
        this.expireUntil(earliest, latestSnapshotId - (long)this.numRetainedMin + 1L);
    }

    @VisibleForTesting
    public void expireUntil(long earliestId, long endExclusiveId) {
        Snapshot snapshot;
        long id;
        OptionalLong minNextSnapshot = this.consumerManager.minNextSnapshot();
        if (minNextSnapshot.isPresent()) {
            endExclusiveId = Math.min(minNextSnapshot.getAsLong(), endExclusiveId);
        }
        if (endExclusiveId <= earliestId) {
            if (this.snapshotManager.readHint("EARLIEST") == null) {
                this.writeEarliestHint(endExclusiveId);
            }
            return;
        }
        long beginInclusiveId = earliestId;
        for (long id2 = endExclusiveId - 1L; id2 >= earliestId; --id2) {
            if (this.snapshotManager.snapshotExists(id2)) continue;
            beginInclusiveId = id2 + 1L;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Snapshot expire range is [" + beginInclusiveId + ", " + endExclusiveId + ")");
        }
        List<Snapshot> taggedSnapshots = this.tagManager.taggedSnapshots();
        for (id = beginInclusiveId + 1L; id <= endExclusiveId; ++id) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete merge tree files not used by snapshot #" + id);
            }
            snapshot = this.snapshotManager.snapshot(id);
            this.snapshotDeletion.cleanUnusedDataFiles(snapshot, this.snapshotDeletion.dataFileSkipper(taggedSnapshots, id));
        }
        for (id = beginInclusiveId; id < endExclusiveId; ++id) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete changelog files from snapshot #" + id);
            }
            if ((snapshot = this.snapshotManager.snapshot(id)).changelogManifestList() == null) continue;
            this.snapshotDeletion.deleteAddedDataFiles(snapshot.changelogManifestList());
        }
        this.snapshotDeletion.cleanDataDirectories();
        List<Snapshot> skippingSnapshots = TagManager.findOverlappedSnapshots(taggedSnapshots, beginInclusiveId, endExclusiveId);
        skippingSnapshots.add(this.snapshotManager.snapshot(endExclusiveId));
        Set<String> skippingSet = this.snapshotDeletion.manifestSkippingSet(skippingSnapshots);
        for (long id3 = beginInclusiveId; id3 < endExclusiveId; ++id3) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete manifests in snapshot #" + id3);
            }
            Snapshot snapshot2 = this.snapshotManager.snapshot(id3);
            this.snapshotDeletion.cleanUnusedManifests(snapshot2, skippingSet);
            this.snapshotManager.fileIO().deleteQuietly(this.snapshotManager.snapshotPath(id3));
        }
        this.writeEarliestHint(endExclusiveId);
    }

    private void writeEarliestHint(long earliest) {
        Callable<Void> callable = () -> {
            this.snapshotManager.commitEarliestHint(earliest);
            return null;
        };
        try {
            if (this.lock != null) {
                this.lock.runWithLock(callable);
            } else {
                callable.call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    SnapshotDeletion snapshotDeletion() {
        return this.snapshotDeletion;
    }
}

