/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.Preconditions;

public class ValueCountMergeFunction
implements MergeFunction<KeyValue> {
    private KeyValue latestKv;
    private long total;
    private KeyValue reused;

    protected ValueCountMergeFunction() {
    }

    @Override
    public void reset() {
        this.latestKv = null;
        this.total = 0L;
    }

    @Override
    public void add(KeyValue kv) {
        Preconditions.checkArgument((kv.valueKind() == RowKind.INSERT ? 1 : 0) != 0, (Object)"In value count mode, only insert records come. This is a bug. Please file an issue.");
        this.latestKv = kv;
        this.total += this.count(kv.value());
    }

    @Override
    @Nullable
    public KeyValue getResult() {
        if (this.total == 0L) {
            return null;
        }
        if (this.reused == null) {
            this.reused = new KeyValue();
        }
        return this.reused.replace(this.latestKv.key(), this.latestKv.sequenceNumber(), RowKind.INSERT, (InternalRow)GenericRow.of((Object[])new Object[]{this.total}));
    }

    private long count(InternalRow value) {
        Preconditions.checkArgument((!value.isNullAt(0) ? 1 : 0) != 0, (Object)"Value count should not be null.");
        return value.getLong(0);
    }

    public static MergeFunctionFactory<KeyValue> factory() {
        return new Factory();
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;

        private Factory() {
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            return new ValueCountMergeFunction();
        }
    }
}

