/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.LoserTree;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.SortMergeReader;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.Preconditions;

public class SortMergeReaderWithLoserTree<T>
implements SortMergeReader<T> {
    private final MergeFunctionWrapper<T> mergeFunctionWrapper;
    private final LoserTree<KeyValue> loserTree;

    public SortMergeReaderWithLoserTree(List<RecordReader<KeyValue>> readers, Comparator<InternalRow> userKeyComparator, MergeFunctionWrapper<T> mergeFunctionWrapper) {
        this.mergeFunctionWrapper = mergeFunctionWrapper;
        this.loserTree = new LoserTree(readers, (e1, e2) -> userKeyComparator.compare(e2.key(), e1.key()), (e1, e2) -> Long.compare(e2.sequenceNumber(), e1.sequenceNumber()));
    }

    @Nullable
    public RecordReader.RecordIterator<T> readBatch() throws IOException {
        this.loserTree.initializeIfNeeded();
        return this.loserTree.peekWinner() == null ? null : new SortMergeIterator();
    }

    public void close() throws IOException {
        this.loserTree.close();
    }

    private class SortMergeIterator
    implements RecordReader.RecordIterator<T> {
        private boolean released = false;

        private SortMergeIterator() {
        }

        @Nullable
        public T next() throws IOException {
            Object result;
            do {
                SortMergeReaderWithLoserTree.this.loserTree.adjustForNextLoop();
                KeyValue winner = (KeyValue)SortMergeReaderWithLoserTree.this.loserTree.popWinner();
                if (winner == null) {
                    return null;
                }
                SortMergeReaderWithLoserTree.this.mergeFunctionWrapper.reset();
                SortMergeReaderWithLoserTree.this.mergeFunctionWrapper.add(winner);
            } while ((result = this.merge()) == null);
            return result;
        }

        private T merge() {
            Preconditions.checkState((!this.released ? 1 : 0) != 0, (Object)"SortMergeIterator#nextImpl is called after release");
            while (SortMergeReaderWithLoserTree.this.loserTree.peekWinner() != null) {
                SortMergeReaderWithLoserTree.this.mergeFunctionWrapper.add((KeyValue)SortMergeReaderWithLoserTree.this.loserTree.popWinner());
            }
            return SortMergeReaderWithLoserTree.this.mergeFunctionWrapper.getResult();
        }

        public void releaseBatch() {
            this.released = true;
        }
    }
}

