/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.List;
import java.util.Optional;
import org.apache.paimon.compact.CompactUnit;
import org.apache.paimon.mergetree.LevelSortedRun;
import org.apache.paimon.mergetree.compact.CompactStrategy;
import org.apache.paimon.mergetree.compact.UniversalCompaction;

public class LookupCompaction
implements CompactStrategy {
    private final UniversalCompaction universalCompaction;

    public LookupCompaction(UniversalCompaction universalCompaction) {
        this.universalCompaction = universalCompaction;
    }

    @Override
    public Optional<CompactUnit> pick(int numLevels, List<LevelSortedRun> runs) {
        int candidateCount;
        Optional<CompactUnit> pick = this.universalCompaction.pick(numLevels, runs);
        if (pick.isPresent()) {
            return pick;
        }
        if (runs.isEmpty() || runs.get(0).level() > 0) {
            return Optional.empty();
        }
        for (int i = candidateCount = 1; i < runs.size() && runs.get(i).level() <= 0; ++i) {
            ++candidateCount;
        }
        return Optional.of(this.universalCompaction.pickForSizeRatio(numLevels - 1, runs, candidateCount, true));
    }
}

